/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeVirtualHost
extends UpgradeProcess {
    protected void addVirtualHost(long virtualHostId, long companyId, long layoutSetId, String hostname) throws Exception {
        if (hostname == null) {
            return;
        }
        this.runSQL("insert into VirtualHost (virtualHostId, companyId, layoutSetId, hostname) values (" + virtualHostId + ", " + companyId + ", " + layoutSetId + ", '" + hostname + "')");
    }

    protected void doUpgrade() throws Exception {
        this.updateCompany();
        this.updateLayoutSet();
    }

    protected void updateCompany() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select companyId, virtualHost from Company where virtualHost != ''");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                String hostname = rs.getString("virtualHost");
                long virtualHostId = this.increment();
                this.addVirtualHost(virtualHostId, companyId, 0L, hostname);
            }
            this.runSQL("alter table Company drop column virtualHost");
        }
    }

    protected void updateLayoutSet() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select layoutSetId, companyId, virtualHost from LayoutSet where virtualHost != ''");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long layoutSetId = rs.getLong("layoutSetId");
                long companyId = rs.getLong("companyId");
                String hostname = rs.getString("virtualHost");
                long virtualHostId = this.increment();
                this.addVirtualHost(virtualHostId, companyId, layoutSetId, hostname);
            }
            this.runSQL("alter table LayoutSet drop column virtualHost");
        }
    }
}

