/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_5;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateUUIDs();
    }

    protected void updateUUID(long groupId, long liveGroupId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select plid, privateLayout, layoutId, friendlyURL from Layout where groupId = ?");){
            ps.setLong(1, groupId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long plid = rs.getLong("plid");
                    boolean privateLayout = rs.getBoolean("privateLayout");
                    long layoutId = rs.getLong("layoutId");
                    String friendlyURL = rs.getString("friendlyURL");
                    this.updateUUID(plid, liveGroupId, privateLayout, layoutId, friendlyURL);
                }
            }
        }
    }

    protected void updateUUID(long plid, long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select uuid_ from Layout where groupId = ? and friendlyURL = ?");){
            ps.setLong(1, groupId);
            ps.setString(2, friendlyURL);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    try (PreparedStatement ps2 = this.connection.prepareStatement("select uuid_ from Layout where groupId = ? and privateLayout = ? and layoutId = ?");){
                        ps2.setLong(1, groupId);
                        ps2.setBoolean(2, privateLayout);
                        ps2.setLong(3, layoutId);
                        try (ResultSet rs2 = ps2.executeQuery();){
                            if (!rs2.next()) {
                                return;
                            }
                        }
                    }
                }
                String uuid = rs.getString("uuid_");
                this.runSQL("update Layout set uuid_ = '" + uuid + "' where plid = " + plid);
            }
        }
    }

    protected void updateUUIDs() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select groupId, liveGroupId from Group_ where liveGroupId != 0");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long liveGroupId = rs.getLong("liveGroupId");
                this.updateUUID(groupId, liveGroupId);
            }
        }
    }
}

