/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.AbstractTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public abstract class AbstractMultiResourceTemplate
extends AbstractTemplate {
    protected List<TemplateResource> templateResources;

    public AbstractMultiResourceTemplate(List<TemplateResource> templateResources, TemplateResource errorTemplateResource, Map<String, Object> context, TemplateContextHelper templateContextHelper, String templateManagerName, long interval) {
        super(errorTemplateResource, context, templateContextHelper, templateManagerName);
        if (ListUtil.isEmpty(templateResources)) {
            throw new IllegalArgumentException("Template resource is null");
        }
        this.templateResources = templateResources;
    }

    public void doProcessTemplate(Writer writer) throws Exception {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        this.put("writer", (Object)unsyncStringWriter);
        this.processTemplates(this.templateResources, (Writer)unsyncStringWriter);
        StringBundler sb = unsyncStringWriter.getStringBundler();
        sb.writeTo(writer);
    }

    public void processTemplate(Writer writer) throws TemplateException {
        if (this.errorTemplateResource == null) {
            try {
                this.processTemplates(this.templateResources, writer);
                return;
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                for (TemplateResource templateResource : this.templateResources) {
                    sb.append(templateResource.getTemplateId());
                    sb.append(",");
                }
                throw new TemplateException("Unable to process templates", (Throwable)e);
            }
        }
        this._write(writer);
    }

    protected abstract void processTemplates(List<TemplateResource> var1, Writer var2) throws Exception;
}

