/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchWebDAVPropsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.service.base.WebDAVPropsLocalServiceBaseImpl;
import java.util.Date;

public class WebDAVPropsLocalServiceImpl
extends WebDAVPropsLocalServiceBaseImpl {
    public void deleteWebDAVProps(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        try {
            this.webDAVPropsPersistence.removeByC_C(classNameId, classPK);
        }
        catch (NoSuchWebDAVPropsException nswdavpe) {
            // empty catch block
        }
    }

    public WebDAVProps getWebDAVProps(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        WebDAVProps webDavProps = this.webDAVPropsPersistence.fetchByC_C(classNameId, classPK);
        if (webDavProps == null) {
            webDavProps = this.webDAVPropsPersistence.create(this.counterLocalService.increment());
            Date now = new Date();
            webDavProps.setCompanyId(companyId);
            webDavProps.setCreateDate(now);
            webDavProps.setModifiedDate(now);
            webDavProps.setClassNameId(classNameId);
            webDavProps.setClassPK(classPK);
            this.webDAVPropsLocalService.updateWebDAVProps(webDavProps);
        }
        return webDavProps;
    }

    public void storeWebDAVProps(WebDAVProps webDavProps) throws PortalException {
        try {
            webDavProps.store();
        }
        catch (Exception e) {
            throw new WebDAVException("Problem trying to store WebDAVProps", (Throwable)e);
        }
        this.webDAVPropsPersistence.update((BaseModel)webDavProps);
    }
}

