/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchUserGroupGroupRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.service.persistence.UserGroupGroupRolePK;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.UserGroupGroupRoleLocalServiceBaseImpl;
import java.util.List;

public class UserGroupGroupRoleLocalServiceImpl
extends UserGroupGroupRoleLocalServiceBaseImpl {
    public void addUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByPrimaryKey(pk);
            if (userGroupGroupRole != null) continue;
            userGroupGroupRole = this.userGroupGroupRolePersistence.create(pk);
            this.userGroupGroupRolePersistence.update((BaseModel)userGroupGroupRole);
        }
        PermissionCacheUtil.clearCache();
    }

    public void addUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) {
        for (long userGroupId : userGroupIds) {
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByPrimaryKey(pk);
            if (userGroupGroupRole != null) continue;
            userGroupGroupRole = this.userGroupGroupRolePersistence.create(pk);
            this.userGroupGroupRolePersistence.update((BaseModel)userGroupGroupRole);
        }
        PermissionCacheUtil.clearCache();
    }

    @Override
    public UserGroupGroupRole deleteUserGroupGroupRole(UserGroupGroupRole userGroupGroupRole) {
        this.userGroupGroupRolePersistence.remove((BaseModel)userGroupGroupRole);
        PermissionCacheUtil.clearCache();
        return userGroupGroupRole;
    }

    public void deleteUserGroupGroupRoles(long groupId, int roleType) {
        List userGroupGroupRoles = this.userGroupGroupRoleFinder.findByGroupRoleType(groupId, roleType);
        for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
            this.userGroupGroupRolePersistence.removeByG_R(groupId, userGroupGroupRole.getRoleId());
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            try {
                this.userGroupGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupGroupRoleException nsuggre) {
                // empty catch block
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long[] groupIds) {
        for (long groupId : groupIds) {
            this.userGroupGroupRolePersistence.removeByU_G(userGroupId, groupId);
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId) {
        for (long userGroupId : userGroupIds) {
            this.userGroupGroupRolePersistence.removeByU_G(userGroupId, groupId);
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) {
        for (long userGroupId : userGroupIds) {
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            try {
                this.userGroupGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupGroupRoleException nsuggre) {
                // empty catch block
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRolesByGroupId(long groupId) {
        this.userGroupGroupRolePersistence.removeByGroupId(groupId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRolesByRoleId(long roleId) {
        this.userGroupGroupRolePersistence.removeByRoleId(roleId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRolesByUserGroupId(long userGroupId) {
        this.userGroupGroupRolePersistence.removeByUserGroupId(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    public List<UserGroupGroupRole> getUserGroupGroupRoles(long userGroupId) {
        return this.userGroupGroupRolePersistence.findByUserGroupId(userGroupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRoles(long userGroupId, long groupId) {
        return this.userGroupGroupRolePersistence.findByU_G(userGroupId, groupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRolesByGroupAndRole(long groupId, long roleId) {
        return this.userGroupGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRolesByUser(long userId) {
        return this.userGroupGroupRoleFinder.findByUserGroupsUsers(userId);
    }

    public boolean hasUserGroupGroupRole(long userGroupId, long groupId, long roleId) {
        UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
        UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByPrimaryKey(pk);
        return userGroupGroupRole != null;
    }

    public boolean hasUserGroupGroupRole(long userGroupId, long groupId, String roleName) throws PortalException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        long companyId = userGroup.getCompanyId();
        Role role = this.rolePersistence.findByC_N(companyId, roleName);
        long roleId = role.getRoleId();
        return this.hasUserGroupGroupRole(userGroupId, groupId, roleId);
    }
}

