/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortalPreferencesLocalServiceBaseImpl;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import javax.portlet.PortletPreferences;

public class PortalPreferencesLocalServiceImpl
extends PortalPreferencesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalPreferencesLocalServiceImpl.class);

    public com.liferay.portal.kernel.model.PortalPreferences addPortalPreferences(long ownerId, int ownerType, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences;
        block4: {
            PortalPreferencesWrapperCacheUtil.remove(ownerId, ownerType);
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = "<portlet-preferences />";
            }
            portalPreferences.setPreferences(defaultPreferences);
            try {
                this.portalPreferencesPersistence.update((BaseModel)portalPreferences);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {ownerId=" + ownerId + ", ownerType=" + ownerType + "}"));
                }
                if ((portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType, false)) != null) break block4;
                throw se;
            }
        }
        return portalPreferences;
    }

    public PortletPreferences getPreferences(long ownerId, int ownerType) {
        return this.getPreferences(ownerId, ownerType, null);
    }

    public PortletPreferences getPreferences(long ownerId, int ownerType, String defaultPreferences) {
        PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
        if (portalPreferencesWrapper != null) {
            return portalPreferencesWrapper.clone();
        }
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            portalPreferences = this.portalPreferencesLocalService.addPortalPreferences(ownerId, ownerType, defaultPreferences);
        }
        PortalPreferencesImpl portalPreferencesImpl = new PortalPreferencesImpl(portalPreferences, false);
        portalPreferencesWrapper = new PortalPreferencesWrapper(portalPreferencesImpl);
        PortalPreferencesWrapperCacheUtil.put(ownerId, ownerType, portalPreferencesWrapper);
        return portalPreferencesWrapper.clone();
    }

    public com.liferay.portal.kernel.model.PortalPreferences updatePreferences(long ownerId, int ownerType, PortalPreferences portalPreferences) {
        String xml = PortletPreferencesFactoryUtil.toXML((PortalPreferences)portalPreferences);
        return this.updatePreferences(ownerId, ownerType, xml);
    }

    public com.liferay.portal.kernel.model.PortalPreferences updatePreferences(long ownerId, int ownerType, String xml) {
        PortalPreferencesWrapperCacheUtil.remove(ownerId, ownerType);
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
        }
        portalPreferences.setPreferences(xml);
        this.portalPreferencesPersistence.update((BaseModel)portalPreferences);
        return portalPreferences;
    }
}

