/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso;

import com.liferay.portal.kernel.security.sso.SSO;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class SSOUtil {
    private static final SSOUtil _instance = new SSOUtil();
    private final ServiceTracker<SSO, SSO> _serviceTracker;
    private final Map<ServiceReference<SSO>, SSO> _ssoMap = new ConcurrentSkipListMap(Collections.reverseOrder());

    public static String getSessionExpirationRedirectURL(long companyId, String sessionExpirationRedirectURL) {
        if (SSOUtil._instance._ssoMap.isEmpty()) {
            return sessionExpirationRedirectURL;
        }
        return _instance._getSessionExpirationRedirectUrl(companyId);
    }

    public static String getSignInURL(long companyId, String signInURL) {
        if (SSOUtil._instance._ssoMap.isEmpty()) {
            return null;
        }
        return _instance._getSignInUrl(companyId, signInURL);
    }

    public static boolean isLoginRedirectRequired(long companyId) {
        if (PrefsPropsUtil.getBoolean(companyId, "login.dialog.disabled", PropsValues.LOGIN_DIALOG_DISABLED)) {
            return true;
        }
        if (SSOUtil._instance._ssoMap.isEmpty()) {
            return false;
        }
        return _instance._isLoginRedirectRequired(companyId);
    }

    public static boolean isRedirectRequired(long companyId) {
        if (SSOUtil._instance._ssoMap.isEmpty()) {
            return false;
        }
        return _instance._isRedirectRequired(companyId);
    }

    public static boolean isSessionRedirectOnExpire(long companyId) {
        boolean sessionRedirectOnExpire = PropsValues.SESSION_TIMEOUT_REDIRECT_ON_EXPIRE;
        if (SSOUtil._instance._ssoMap.isEmpty()) {
            return sessionRedirectOnExpire;
        }
        if (PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED) && PropsValues.OPEN_SSO_LOGOUT_ON_SESSION_EXPIRATION) {
            return true;
        }
        return _instance._isSessionRedirectOnExpire(companyId);
    }

    private SSOUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(SSO.class, (ServiceTrackerCustomizer)new SSOServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private String _getSessionExpirationRedirectUrl(long companyId) {
        for (SSO sso : this._ssoMap.values()) {
            String sessionExpirationRedirectUrl = sso.getSessionExpirationRedirectUrl(companyId);
            if (sessionExpirationRedirectUrl == null) continue;
            return sessionExpirationRedirectUrl;
        }
        return null;
    }

    private String _getSignInUrl(long companyId, String defaultSignInURL) {
        for (SSO sso : this._ssoMap.values()) {
            String signInURL = sso.getSignInURL(companyId, defaultSignInURL);
            if (signInURL == null) continue;
            return signInURL;
        }
        return null;
    }

    private boolean _isLoginRedirectRequired(long companyId) {
        for (SSO sso : this._ssoMap.values()) {
            if (!sso.isLoginRedirectRequired(companyId)) continue;
            return true;
        }
        return false;
    }

    private boolean _isRedirectRequired(long companyId) {
        for (SSO sso : this._ssoMap.values()) {
            if (!sso.isRedirectRequired(companyId)) continue;
            return true;
        }
        return false;
    }

    private boolean _isSessionRedirectOnExpire(long companyId) {
        for (SSO sso : this._ssoMap.values()) {
            if (!sso.isSessionRedirectOnExpire(companyId)) continue;
            return true;
        }
        return false;
    }

    private class SSOServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SSO, SSO> {
        private SSOServiceTrackerCustomizer() {
        }

        public SSO addingService(ServiceReference<SSO> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            SSO sso = (SSO)registry.getService(serviceReference);
            SSOUtil.this._ssoMap.put(serviceReference, sso);
            return sso;
        }

        public void modifiedService(ServiceReference<SSO> serviceReference, SSO sso) {
        }

        public void removedService(ServiceReference<SSO> serviceReference, SSO sso) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            SSOUtil.this._ssoMap.remove(serviceReference);
        }
    }
}

