/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileVersionLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LiferayFileEntry
extends LiferayModel
implements FileEntry {
    private static final Log _log = LogFactoryUtil.getLog(LiferayFileEntry.class);
    private final DLFileEntry _dlFileEntry;
    private DLFileVersion _dlFileVersion;
    private final boolean _escapedModel;

    public LiferayFileEntry(DLFileEntry dlFileEntry) {
        this(dlFileEntry, dlFileEntry.isEscapedModel());
    }

    public LiferayFileEntry(DLFileEntry fileEntry, boolean escapedModel) {
        this._dlFileEntry = fileEntry;
        this._escapedModel = escapedModel;
    }

    public Object clone() {
        return new LiferayFileEntry(this._dlFileEntry);
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._dlFileEntry, actionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiferayFileEntry)) {
            return false;
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)obj;
        return Validator.equals((Object)this._dlFileEntry, (Object)liferayFileEntry._dlFileEntry);
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((FileEntry)this);
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    public FileVersion getCachedFileVersion() {
        if (this._dlFileVersion == null) {
            return null;
        }
        return new LiferayFileVersion(this._dlFileVersion);
    }

    @Override
    public long getCompanyId() {
        return this._dlFileEntry.getCompanyId();
    }

    public InputStream getContentStream() throws PortalException {
        InputStream inputStream = this._dlFileEntry.getContentStream();
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return inputStream;
    }

    public InputStream getContentStream(String version) throws PortalException {
        InputStream inputStream = this._dlFileEntry.getContentStream(version);
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return inputStream;
    }

    public Date getCreateDate() {
        return this._dlFileEntry.getCreateDate();
    }

    public String getDescription() {
        return this._dlFileEntry.getDescription();
    }

    public DLFileEntry getDLFileEntry() {
        return this._dlFileEntry;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileEntry.getExpandoBridge();
    }

    public String getExtension() {
        return this._dlFileEntry.getExtension();
    }

    public long getFileEntryId() {
        return this._dlFileEntry.getFileEntryId();
    }

    public String getFileName() {
        return this._dlFileEntry.getFileName();
    }

    public List<FileShortcut> getFileShortcuts() {
        return RepositoryModelUtil.toFileShortcuts(this._dlFileEntry.getFileShortcuts());
    }

    public FileVersion getFileVersion() throws PortalException {
        DLFileVersion dlFileVersion = this._dlFileVersion;
        if (dlFileVersion == null) {
            dlFileVersion = this._dlFileEntry.getFileVersion();
        }
        return new LiferayFileVersion(dlFileVersion);
    }

    public FileVersion getFileVersion(String version) throws PortalException {
        return new LiferayFileVersion(this._dlFileEntry.getFileVersion(version));
    }

    public List<FileVersion> getFileVersions(int status) {
        return RepositoryModelUtil.toFileVersions(this._dlFileEntry.getFileVersions(status));
    }

    public int getFileVersionsCount(int status) {
        return this._dlFileEntry.getFileVersionsCount(status);
    }

    public Folder getFolder() {
        LiferayFolder folder = null;
        try {
            folder = new LiferayFolder(this._dlFileEntry.getFolder());
        }
        catch (Exception e) {
            return null;
        }
        return folder;
    }

    public long getFolderId() {
        return this._dlFileEntry.getFolderId();
    }

    public long getGroupId() {
        return this._dlFileEntry.getGroupId();
    }

    public String getIcon() {
        return this._dlFileEntry.getIcon();
    }

    public String getIconCssClass() {
        return this._dlFileEntry.getIconCssClass();
    }

    public Date getLastPublishDate() {
        return this._dlFileEntry.getLastPublishDate();
    }

    public FileVersion getLatestFileVersion() throws PortalException {
        return this.getLatestFileVersion(false);
    }

    public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        return new LiferayFileVersion(this._dlFileEntry.getLatestFileVersion(trusted));
    }

    public Lock getLock() {
        return this._dlFileEntry.getLock();
    }

    public String getMimeType() {
        return this._dlFileEntry.getMimeType();
    }

    public String getMimeType(String version) {
        try {
            DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)this._dlFileEntry.getFileEntryId(), (String)version);
            return dlFileVersion.getMimeType();
        }
        catch (Exception exception) {
            return "application/octet-stream";
        }
    }

    public Object getModel() {
        return this._dlFileEntry;
    }

    public Class<?> getModelClass() {
        return LiferayFileEntry.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFileEntry.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFileEntry.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileEntry.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public int getReadCount() {
        return this._dlFileEntry.getReadCount();
    }

    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        Repository repository = this.getRepository();
        return (T)repository.getCapability(capabilityClass);
    }

    public long getRepositoryId() {
        return this._dlFileEntry.getRepositoryId();
    }

    public long getSize() {
        return this._dlFileEntry.getSize();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    public String getTitle() {
        return this._dlFileEntry.getTitle();
    }

    public long getUserId() {
        return this._dlFileEntry.getUserId();
    }

    public String getUserName() {
        return this._dlFileEntry.getUserName();
    }

    public String getUserUuid() {
        return this._dlFileEntry.getUserUuid();
    }

    public String getUuid() {
        return this._dlFileEntry.getUuid();
    }

    public String getVersion() {
        return this._dlFileEntry.getVersion();
    }

    @Deprecated
    public long getVersionUserId() {
        long versionUserId = 0L;
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserId = dlFileVersion.getUserId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return versionUserId;
    }

    @Deprecated
    public String getVersionUserName() {
        String versionUserName = "";
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserName = dlFileVersion.getUserName();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return versionUserName;
    }

    @Deprecated
    public String getVersionUserUuid() {
        String versionUserUuid = "";
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserUuid = dlFileVersion.getUserUuid();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return versionUserUuid;
    }

    public int hashCode() {
        return this._dlFileEntry.hashCode();
    }

    public boolean hasLock() {
        return this._dlFileEntry.hasLock();
    }

    public boolean isCheckedOut() {
        return this._dlFileEntry.isCheckedOut();
    }

    public boolean isDefaultRepository() {
        return this._dlFileEntry.getGroupId() == this._dlFileEntry.getRepositoryId();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isInTrash() {
        return this._dlFileEntry.isInTrash();
    }

    public boolean isInTrashContainer() {
        try {
            return this._dlFileEntry.isInTrashContainer();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isManualCheckInRequired() {
        return this._dlFileEntry.isManualCheckInRequired();
    }

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this.getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return true;
    }

    public boolean isSupportsSocial() {
        return true;
    }

    public void setCachedFileVersion(FileVersion fileVersion) {
        this._dlFileVersion = (DLFileVersion)fileVersion.getModel();
    }

    public void setCompanyId(long companyId) {
        this._dlFileEntry.setCompanyId(companyId);
    }

    public void setCreateDate(Date createDate) {
        this._dlFileEntry.setCreateDate(createDate);
    }

    public void setGroupId(long groupId) {
        this._dlFileEntry.setGroupId(groupId);
    }

    public void setLastPublishDate(Date lastPublishDate) {
        this._dlFileEntry.setLastPublishDate(lastPublishDate);
    }

    public void setModifiedDate(Date modifiedDate) {
        this._dlFileEntry.setModifiedDate(modifiedDate);
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileEntry.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFileEntry.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFileEntry.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFileEntry.setUserUuid(userUuid);
    }

    public void setUuid(String uuid) {
        this._dlFileEntry.setUuid(uuid);
    }

    public FileEntry toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileEntry(this._dlFileEntry.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFileEntry.toString();
    }

    public FileEntry toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFileEntry(this._dlFileEntry.toUnescapedModel(), true);
        }
        return this;
    }

    protected Repository getRepository() {
        try {
            return RepositoryProviderUtil.getRepository((long)this.getRepositoryId());
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to get repository for file entry " + this.getFileEntryId(), (Throwable)pe);
        }
    }
}

