/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLSyncEvent;
import com.liferay.document.library.kernel.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.TrashRepositoryEventType;
import com.liferay.portal.kernel.repository.event.WorkflowRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.repository.capabilities.util.GroupServiceAdapter;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class LiferaySyncCapability
implements RepositoryEventAware,
SyncCapability {
    private final RepositoryEventListener<RepositoryEventType.Add, Folder> _ADD_FOLDER_EVENT_LISTENER = new SyncFolderRepositoryEventListener<RepositoryEventType.Add>("add");
    private final RepositoryEventListener<RepositoryEventType.Delete, FileEntry> _DELETE_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<RepositoryEventType.Delete>("delete");
    private final RepositoryEventListener<RepositoryEventType.Delete, Folder> _DELETE_FOLDER_EVENT_LISTENER = new SyncFolderRepositoryEventListener<RepositoryEventType.Delete>("delete");
    private final RepositoryEventListener<RepositoryEventType.Move, FileEntry> _MOVE_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<RepositoryEventType.Move>("move");
    private final RepositoryEventListener<RepositoryEventType.Move, Folder> _MOVE_FOLDER_EVENT_LISTENER = new SyncFolderRepositoryEventListener<RepositoryEventType.Move>("move");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryRestored, FileEntry> _RESTORE_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<TrashRepositoryEventType.EntryRestored>("restore");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryRestored, Folder> _RESTORE_FOLDER_EVENT_LISTENER = new SyncFolderRepositoryEventListener<TrashRepositoryEventType.EntryRestored>("restore");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryTrashed, FileEntry> _TRASH_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<TrashRepositoryEventType.EntryTrashed>("trash");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryTrashed, Folder> _TRASH_FOLDER_EVENT_LISTENER = new SyncFolderRepositoryEventListener<TrashRepositoryEventType.EntryTrashed>("trash");
    private final RepositoryEventListener<RepositoryEventType.Update, FileEntry> _UPDATE_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<RepositoryEventType.Update>("update");
    private final RepositoryEventListener<RepositoryEventType.Update, Folder> _UPDATE_FOLDER_EVENT_LISTENER = new SyncFolderRepositoryEventListener<RepositoryEventType.Update>("update");
    private final RepositoryEventListener<WorkflowRepositoryEventType.Add, FileEntry> _WORKFLOW_ADD_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<WorkflowRepositoryEventType.Add>("add");
    private final RepositoryEventListener<WorkflowRepositoryEventType.Update, FileEntry> _WORKFLOW_UPDATE_FILE_ENTRY_EVENT_LISTENER = new SyncFileEntryRepositoryEventListener<WorkflowRepositoryEventType.Update>("update");
    private final DLSyncEventLocalService _dlSyncEventLocalService;
    private final GroupServiceAdapter _groupServiceAdapter;

    public LiferaySyncCapability(GroupServiceAdapter groupServiceAdapter, DLSyncEventLocalService dlSyncEventLocalService) {
        this._groupServiceAdapter = groupServiceAdapter;
        this._dlSyncEventLocalService = dlSyncEventLocalService;
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Add.class, Folder.class, this._ADD_FOLDER_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, this._DELETE_FILE_ENTRY_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, Folder.class, this._DELETE_FOLDER_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Move.class, FileEntry.class, this._MOVE_FILE_ENTRY_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Move.class, Folder.class, this._MOVE_FOLDER_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryRestored.class, FileEntry.class, this._RESTORE_FILE_ENTRY_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryRestored.class, Folder.class, this._RESTORE_FOLDER_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryTrashed.class, FileEntry.class, this._TRASH_FILE_ENTRY_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryTrashed.class, Folder.class, this._TRASH_FOLDER_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Update.class, FileEntry.class, this._UPDATE_FILE_ENTRY_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Update.class, Folder.class, this._UPDATE_FOLDER_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(WorkflowRepositoryEventType.Add.class, FileEntry.class, this._WORKFLOW_ADD_FILE_ENTRY_EVENT_LISTENER);
        repositoryEventRegistry.registerRepositoryEventListener(WorkflowRepositoryEventType.Update.class, FileEntry.class, this._WORKFLOW_UPDATE_FILE_ENTRY_EVENT_LISTENER);
    }

    protected boolean isStagingGroup(long groupId) {
        try {
            Group group = this._groupServiceAdapter.getGroup(groupId);
            return group.isStagingGroup();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void registerDLSyncEventCallback(String event, FileEntry fileEntry) {
        if (this.isStagingGroup(fileEntry.getGroupId()) || !(fileEntry instanceof LiferayFileEntry)) {
            return;
        }
        this.registerDLSyncEventCallback(event, "file", fileEntry.getFileEntryId());
    }

    protected void registerDLSyncEventCallback(String event, Folder folder) {
        if (this.isStagingGroup(folder.getGroupId()) || !(folder instanceof LiferayFolder)) {
            return;
        }
        this.registerDLSyncEventCallback(event, "folder", folder.getFolderId());
    }

    protected void registerDLSyncEventCallback(final String event, final String type, final long typePK) {
        DLSyncEvent dlSyncEvent = this._dlSyncEventLocalService.addDLSyncEvent(event, type, typePK);
        final long modifiedTime = dlSyncEvent.getModifiedTime();
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                HashMap<String, Object> values = new HashMap<String, Object>(4);
                values.put("event", event);
                values.put("modifiedTime", modifiedTime);
                values.put("type", type);
                values.put("typePK", typePK);
                message.setValues(values);
                MessageBusUtil.sendMessage((String)"liferay/document_library_sync_event_processor", (Message)message);
                return null;
            }
        });
    }

    private class SyncFolderRepositoryEventListener<S extends RepositoryEventType>
    implements RepositoryEventListener<S, Folder> {
        private final String _syncEvent;

        public SyncFolderRepositoryEventListener(String syncEvent) {
            this._syncEvent = syncEvent;
        }

        public void execute(Folder folder) {
            LiferaySyncCapability.this.registerDLSyncEventCallback(this._syncEvent, folder);
        }
    }

    private class SyncFileEntryRepositoryEventListener<S extends RepositoryEventType>
    implements RepositoryEventListener<S, FileEntry> {
        private final String _syncEvent;

        public SyncFileEntryRepositoryEventListener(String syncEvent) {
            this._syncEvent = syncEvent;
        }

        public void execute(FileEntry fileEntry) {
            LiferaySyncCapability.this.registerDLSyncEventCallback(this._syncEvent, fileEntry);
        }
    }
}

