/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.codec.serialization;

import com.liferay.portal.fabric.netty.codec.serialization.ObjectDecodeChannelInboundHandler;
import com.liferay.portal.fabric.netty.util.NettyUtil;
import com.liferay.portal.kernel.io.ProtectedAnnotatedObjectInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.InputStream;
import java.util.Map;

public class AnnotatedObjectDecoder
extends LengthFieldBasedFrameDecoder {
    public static final String NAME = AnnotatedObjectDecoder.class.getName();
    private final ChannelPipeline _channelPipeline = NettyUtil.createEmptyChannelPipeline();

    public AnnotatedObjectDecoder() {
        super(Integer.MAX_VALUE, 0, 4, 0, 4);
    }

    public void addFirst(ObjectDecodeChannelInboundHandler<?> ... objectDecodeChannelInboundHandlers) {
        this._channelPipeline.addFirst(objectDecodeChannelInboundHandlers);
    }

    public void addFirst(String name, ObjectDecodeChannelInboundHandler<?> objectDecodeChannelInboundHandler) {
        this._channelPipeline.addFirst(name, objectDecodeChannelInboundHandler);
    }

    public void addLast(ObjectDecodeChannelInboundHandler<?> ... objectDecodeChannelInboundHandlers) {
        this._channelPipeline.addLast(objectDecodeChannelInboundHandlers);
    }

    public void addLast(String name, ObjectDecodeChannelInboundHandler<?> objectDecodeChannelInboundHandler) {
        this._channelPipeline.addLast(name, objectDecodeChannelInboundHandler);
    }

    public <T extends ObjectDecodeChannelInboundHandler<?>> T remove(Class<T> handlerType) {
        return (T)((Object)((ObjectDecodeChannelInboundHandler)this._channelPipeline.remove(handlerType)));
    }

    public void remove(ObjectDecodeChannelInboundHandler<?> objectDecodeChannelInboundHandler) {
        this._channelPipeline.remove(objectDecodeChannelInboundHandler);
    }

    public ObjectDecodeChannelInboundHandler<?> remove(String name) {
        return (ObjectDecodeChannelInboundHandler)this._channelPipeline.remove(name);
    }

    public ObjectDecodeChannelInboundHandler<?> removeFirst() {
        return (ObjectDecodeChannelInboundHandler)this._channelPipeline.removeFirst();
    }

    public ObjectDecodeChannelInboundHandler<?> removeLast() {
        return (ObjectDecodeChannelInboundHandler)this._channelPipeline.removeLast();
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        ByteBuf decodeByteBuf = (ByteBuf)super.decode(channelHandlerContext, byteBuf);
        if (decodeByteBuf == null) {
            return null;
        }
        ProtectedAnnotatedObjectInputStream objectInputStream = new ProtectedAnnotatedObjectInputStream((InputStream)new ByteBufInputStream(decodeByteBuf));
        Object object = objectInputStream.readObject();
        for (Map.Entry entry : this._channelPipeline) {
            ObjectDecodeChannelInboundHandler objectDecodeChannelInboundHandler = (ObjectDecodeChannelInboundHandler)((Object)entry.getValue());
            object = objectDecodeChannelInboundHandler.channelRead(channelHandlerContext, object, byteBuf);
        }
        return object;
    }

    protected ByteBuf extractFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int index, int length) {
        return byteBuf.slice(index, length);
    }
}

