/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tld.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.util.xml.Dom4jUtil;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TLDFormatter {
    private final Set<String> _modifiedFileNames = new HashSet<String>();
    private final boolean _plugin;

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String baseDirName = GetterUtil.getString(arguments.get("tld.base.dir"), "./");
        boolean plugin = GetterUtil.getBoolean(arguments.get("tld.plugin"), true);
        try {
            new TLDFormatter(baseDirName, plugin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TLDFormatter(String baseDirName, boolean plugin) throws Exception {
        this._plugin = plugin;
        Files.walkFileTree(Paths.get(baseDirName, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                Path fileNamePath = file.getFileName();
                String fileName = fileNamePath.toString();
                if (!fileName.endsWith(".tld") || !TLDFormatter.this._plugin && fileName.equals("liferay-portlet-ext.tld")) {
                    return FileVisitResult.CONTINUE;
                }
                try {
                    TLDFormatter.this._formatTLD(file);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Set<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    private void _formatTLD(Path file) throws Exception {
        String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        SAXReader saxReader = this._getSAXReader();
        Document document = saxReader.read((Reader)new UnsyncStringReader(content));
        Element root = document.getRootElement();
        this._sortElements(root, "tag", "name");
        List tagElements = root.elements("tag");
        for (Element tagElement : tagElements) {
            this._sortElements(tagElement, "attribute", "name");
            Element dynamicAttributesElement = tagElement.element("dynamic-attributes");
            if (dynamicAttributesElement == null) continue;
            dynamicAttributesElement.detach();
            tagElement.add(dynamicAttributesElement);
        }
        String newContent = Dom4jUtil.toString((Node)document);
        int x = newContent.indexOf("<tlib-version");
        int y = newContent.indexOf("</taglib>");
        newContent = newContent.substring(x, y);
        x = content.indexOf("<tlib-version");
        y = content.indexOf("</taglib>");
        newContent = content.substring(0, x) + newContent + content.substring(y);
        if (!content.equals(newContent)) {
            Files.write(file, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this._modifiedFileNames.add(file.toString());
            System.out.println(file);
        }
    }

    private SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private void _sortElements(Element parentElement, String name, String sortBy) {
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        List elements = parentElement.elements(name);
        for (Element element : elements) {
            map.put(element.elementText(sortBy), element);
            element.detach();
        }
        for (Map.Entry entry : map.entrySet()) {
            Element element = (Element)entry.getValue();
            parentElement.add(element);
        }
    }
}

