/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.mail.kernel.model.FileAttachment;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.model.SMTPAccount;
import com.liferay.mail.kernel.service.MailServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.EscapableObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlEscapableObject;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.mail.internet.InternetAddress;

public class SubscriptionSender
implements Serializable {
    protected String body;
    protected boolean bulk;
    protected long companyId;
    protected long creatorUserId;
    protected long currentUserId;
    protected List<FileAttachment> fileAttachments = new ArrayList<FileAttachment>();
    protected String fromAddress;
    protected String fromName;
    protected long groupId;
    protected boolean htmlFormat;
    protected String inReplyTo;
    protected Map<Locale, String> localizedBodyMap;
    protected Map<Locale, String> localizedPortletTitleMap;
    protected Map<Locale, String> localizedSubjectMap;
    protected String mailId;
    protected String portletId;
    protected String replyToAddress;
    protected long scopeGroupId;
    protected ServiceContext serviceContext;
    protected SMTPAccount smtpAccount;
    protected String subject;
    protected boolean uniqueMailId = true;
    private static final Log _log = LogFactoryUtil.getLog(SubscriptionSender.class);
    private List<InternetAddress> _bulkAddresses;
    private transient ClassLoader _classLoader;
    private String _className;
    private long _classPK;
    private final Map<String, EscapableObject<String>> _context = new HashMap<String, EscapableObject<String>>();
    private String _contextCreatorUserPrefix;
    private String _entryTitle;
    private String _entryURL;
    private boolean _initialized;
    private Object[] _mailIdIds;
    private String _mailIdPopPortletPrefix;
    private long _notificationClassNameId;
    private int _notificationType;
    private final List<ObjectValuePair<String, Long>> _persistestedSubscribersOVPs = new ArrayList<ObjectValuePair<String, Long>>();
    private final List<ObjectValuePair<String, String>> _runtimeSubscribersOVPs = new ArrayList<ObjectValuePair<String, String>>();
    private final Set<String> _sentEmailAddresses = new HashSet<String>();

    public void addFileAttachment(File file) {
        this.addFileAttachment(file, null);
    }

    public void addFileAttachment(File file, String fileName) {
        if (file == null) {
            return;
        }
        if (this.fileAttachments == null) {
            this.fileAttachments = new ArrayList<FileAttachment>();
        }
        FileAttachment attachment = new FileAttachment(file, fileName);
        this.fileAttachments.add(attachment);
    }

    public void addPersistedSubscribers(String className, long classPK) {
        ObjectValuePair<String, Long> ovp = new ObjectValuePair<String, Long>(className, classPK);
        this._persistestedSubscribersOVPs.add(ovp);
    }

    public void addRuntimeSubscribers(String toAddress, String toName) {
        ObjectValuePair<String, String> ovp = new ObjectValuePair<String, String>(toAddress, toName);
        this._runtimeSubscribersOVPs.add(ovp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushNotifications() throws Exception {
        this.initialize();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            for (ObjectValuePair<String, Long> objectValuePair : this._persistestedSubscribersOVPs) {
                String className = objectValuePair.getKey();
                long classPK = objectValuePair.getValue();
                List<Subscription> subscriptions = SubscriptionLocalServiceUtil.getSubscriptions(this.companyId, className, classPK);
                for (Subscription subscription : subscriptions) {
                    try {
                        this.notifyPersistedSubscriber(subscription);
                    }
                    catch (Exception e) {
                        _log.error("Unable to process subscription: " + subscription, e);
                    }
                }
            }
            this._persistestedSubscribersOVPs.clear();
            for (ObjectValuePair<String, Object> objectValuePair : this._runtimeSubscribersOVPs) {
                String toAddress = objectValuePair.getKey();
                if (Validator.isNull(toAddress)) continue;
                if (this._sentEmailAddresses.contains(toAddress)) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("Do not send a duplicate email to " + toAddress);
                    continue;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("Add " + toAddress + " to the list of users who " + "have received an email");
                }
                this._sentEmailAddresses.add(toAddress);
                String toName = (String)objectValuePair.getValue();
                InternetAddress to = new InternetAddress(toAddress, toName);
                this.notifyRuntimeSubscriber(to, LocaleUtil.getDefault());
            }
            this._runtimeSubscribersOVPs.clear();
            if (this.bulk) {
                Locale locale = LocaleUtil.getDefault();
                InternetAddress internetAddress = new InternetAddress(this.replaceContent(this.replyToAddress, locale), this.replaceContent(this.replyToAddress, locale));
                this.sendEmail(internetAddress, locale);
            }
        }
        finally {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void flushNotificationsAsync() {
        TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Thread currentThread = Thread.currentThread();
                SubscriptionSender.this._classLoader = currentThread.getContextClassLoader();
                MessageBusUtil.sendMessage("liferay/subscription_sender", SubscriptionSender.this);
                return null;
            }
        });
    }

    public Object getContextAttribute(String key) {
        return this._context.get(key);
    }

    public long getCurrentUserId() {
        return this.currentUserId;
    }

    public String getMailId() {
        return this.mailId;
    }

    @Deprecated
    public long getUserId() {
        return this.getCurrentUserId();
    }

    public void initialize() throws Exception {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this.groupId == 0L && this.serviceContext != null) {
            this.setScopeGroupId(this.serviceContext.getScopeGroupId());
        }
        Company company = CompanyLocalServiceUtil.getCompany(this.companyId);
        this.setContextAttribute("[$COMPANY_ID$]", company.getCompanyId());
        this.setContextAttribute("[$COMPANY_MX$]", company.getMx());
        this.setContextAttribute("[$COMPANY_NAME$]", company.getName());
        this.setContextAttribute("[$PORTAL_URL$]", company.getPortalURL(this.groupId));
        if (this.groupId > 0L) {
            Group group = GroupLocalServiceUtil.getGroup(this.groupId);
            this.setContextAttribute("[$SITE_NAME$]", group.getDescriptiveName());
        }
        if (this.creatorUserId > 0L && Validator.isNotNull(this._contextCreatorUserPrefix)) {
            this.setContextAttribute("[$" + this._contextCreatorUserPrefix + "_USER_ADDRESS$]", PortalUtil.getUserEmailAddress(this.creatorUserId));
            this.setContextAttribute("[$" + this._contextCreatorUserPrefix + "_USER_NAME$]", PortalUtil.getUserName(this.creatorUserId, ""));
        }
        if (this.uniqueMailId) {
            this._mailIdIds = ArrayUtil.append(this._mailIdIds, PortalUUIDUtil.generate());
        }
        this.mailId = PortalUtil.getMailId(company.getMx(), this._mailIdPopPortletPrefix, this._mailIdIds);
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBulk(boolean bulk) {
        this.bulk = bulk;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setCompanyId(long companyId) {
        this.companyId = companyId;
    }

    public void setContextAttribute(String key, EscapableObject<String> value) {
        this._context.put(key, value);
    }

    public void setContextAttribute(String key, Object value) {
        this.setContextAttribute(key, value, true);
    }

    public void setContextAttribute(String key, Object value, boolean escape) {
        this.setContextAttribute(key, new HtmlEscapableObject<String>(String.valueOf(value), escape));
    }

    public void setContextAttributes(Object ... values) {
        for (int i = 0; i < values.length; i += 2) {
            this.setContextAttribute(String.valueOf(values[i]), values[i + 1]);
        }
    }

    public void setContextCreatorUserPrefix(String contextCreatorUserPrefix) {
        this._contextCreatorUserPrefix = contextCreatorUserPrefix;
    }

    public void setCreatorUserId(long creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public void setCurrentUserId(long currentUserId) {
        this.currentUserId = currentUserId;
    }

    public void setEntryTitle(String entryTitle) {
        this._entryTitle = entryTitle;
    }

    public void setEntryURL(String entryURL) {
        this._entryURL = entryURL;
    }

    public void setFrom(String fromAddress, String fromName) {
        this.fromAddress = fromAddress;
        this.fromName = fromName;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public void setHtmlFormat(boolean htmlFormat) {
        this.htmlFormat = htmlFormat;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public void setLocalizedBodyMap(Map<Locale, String> localizedBodyMap) {
        this.localizedBodyMap = localizedBodyMap;
    }

    public void setLocalizedPortletTitleMap(Map<Locale, String> localizedPortletTitleMap) {
        this.localizedPortletTitleMap = localizedPortletTitleMap;
    }

    public void setLocalizedSubjectMap(Map<Locale, String> localizedSubjectMap) {
        this.localizedSubjectMap = localizedSubjectMap;
    }

    public void setMailId(String popPortletPrefix, Object ... ids) {
        this._mailIdPopPortletPrefix = popPortletPrefix;
        this._mailIdIds = ids;
    }

    public void setNotificationClassNameId(long notificationClassNameId) {
        this._notificationClassNameId = notificationClassNameId;
    }

    public void setNotificationType(int notificationType) {
        this._notificationType = notificationType;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public void setScopeGroupId(long scopeGroupId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup(scopeGroupId);
            this.groupId = group.isLayout() ? group.getParentGroupId() : scopeGroupId;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scopeGroupId = scopeGroupId;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setSMTPAccount(SMTPAccount smtpAccount) {
        this.smtpAccount = smtpAccount;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setUniqueMailId(boolean uniqueMailId) {
        this.uniqueMailId = uniqueMailId;
    }

    @Deprecated
    public void setUserId(long userId) {
        this.setCurrentUserId(userId);
    }

    protected void deleteSubscription(Subscription subscription) throws Exception {
        SubscriptionLocalServiceUtil.deleteSubscription(subscription.getSubscriptionId());
    }

    protected boolean hasPermission(Subscription subscription, String className, long classPK, User user) throws Exception {
        if (subscription.getClassName() == null) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
        Boolean hasPermission = null;
        if (Validator.isNotNull(className) && ((hasPermission = BaseModelPermissionCheckerUtil.containsBaseModelPermission(permissionChecker, this.groupId, className, classPK, "VIEW")) == null || !hasPermission.booleanValue())) {
            return false;
        }
        hasPermission = this.hasSubscribePermission(permissionChecker, subscription);
        return hasPermission != null && hasPermission != false;
    }

    protected boolean hasPermission(Subscription subscription, User user) throws Exception {
        return this.hasPermission(subscription, this._className, this._classPK, user);
    }

    protected Boolean hasSubscribePermission(PermissionChecker permissionChecker, Subscription subscription) throws PortalException {
        ResourceAction resourceAction = ResourceActionLocalServiceUtil.fetchResourceAction(subscription.getClassName(), "SUBSCRIBE");
        if (resourceAction != null) {
            return BaseModelPermissionCheckerUtil.containsBaseModelPermission(permissionChecker, this.groupId, subscription.getClassName(), subscription.getClassPK(), "SUBSCRIBE");
        }
        return Boolean.TRUE;
    }

    protected void notifyPersistedSubscriber(Subscription subscription) throws Exception {
        this.notifyPersistedSubscriber(subscription, this._className, this._classPK);
    }

    protected void notifyPersistedSubscriber(Subscription subscription, String className, long classPK) throws Exception {
        User user = UserLocalServiceUtil.fetchUserById(subscription.getUserId());
        if (user == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Subscription " + subscription.getSubscriptionId() + " is stale and will be deleted");
            }
            this.deleteSubscription(subscription);
            return;
        }
        String emailAddress = user.getEmailAddress();
        if (this._sentEmailAddresses.contains(emailAddress)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Do not send a duplicate email to " + emailAddress);
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Add " + emailAddress + " to the list of users who have received an email");
        }
        this._sentEmailAddresses.add(emailAddress);
        if (!user.isActive()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip inactive user " + user.getUserId());
            }
            return;
        }
        try {
            if (!this.hasPermission(subscription, className, classPK, user)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Skip unauthorized user " + user.getUserId());
                }
                return;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            return;
        }
        this.sendNotification(user);
    }

    protected void notifyRuntimeSubscriber(InternetAddress to, Locale locale) throws Exception {
        String emailAddress = to.getAddress();
        User user = UserLocalServiceUtil.fetchUserByEmailAddress(this.companyId, emailAddress);
        if (user == null) {
            if (_log.isInfoEnabled()) {
                _log.info("User with email address " + emailAddress + " does not exist for company " + this.companyId);
            }
            if (this.bulk) {
                if (this._bulkAddresses == null) {
                    this._bulkAddresses = new ArrayList<InternetAddress>();
                }
                this._bulkAddresses.add(to);
                return;
            }
            this.sendEmail(to, locale);
        } else {
            this.sendNotification(user);
        }
    }

    @Deprecated
    protected void notifySubscriber(Subscription subscription, String inferredClassName, long inferredClassPK) throws Exception {
        this.notifyPersistedSubscriber(subscription, inferredClassName, inferredClassPK);
    }

    protected void processMailMessage(MailMessage mailMessage, Locale locale) throws Exception {
        InternetAddress from = mailMessage.getFrom();
        InternetAddress to = mailMessage.getTo()[0];
        String processedSubject = StringUtil.replace(mailMessage.getSubject(), new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, new String[]{from.getAddress(), GetterUtil.getString(from.getPersonal(), from.getAddress()), HtmlUtil.escape(to.getAddress()), HtmlUtil.escape(GetterUtil.getString(to.getPersonal(), to.getAddress()))});
        processedSubject = this.replaceContent(processedSubject, locale, false);
        mailMessage.setSubject(processedSubject);
        String processedBody = StringUtil.replace(mailMessage.getBody(), new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, new String[]{from.getAddress(), GetterUtil.getString(from.getPersonal(), from.getAddress()), HtmlUtil.escape(to.getAddress()), HtmlUtil.escape(GetterUtil.getString(to.getPersonal(), to.getAddress()))});
        processedBody = this.replaceContent(processedBody, locale, this.htmlFormat);
        mailMessage.setBody(processedBody);
    }

    protected String replaceContent(String content, Locale locale) throws Exception {
        return this.replaceContent(content, locale, true);
    }

    protected String replaceContent(String content, Locale locale, boolean escape) throws Exception {
        for (Map.Entry<String, EscapableObject<String>> entry : this._context.entrySet()) {
            String key = entry.getKey();
            EscapableObject<String> value = entry.getValue();
            String valueString = null;
            valueString = escape ? value.getEscapedValue() : value.getOriginalValue();
            content = StringUtil.replace(content, key, valueString);
        }
        String portletName = "";
        if (Validator.isNotNull(this.portletId)) {
            portletName = PortalUtil.getPortletTitle(this.portletId, locale);
            content = StringUtil.replace(content, "[$PORTLET_NAME$]", portletName);
        }
        String portletTitle = portletName;
        if (this.localizedPortletTitleMap != null) {
            if (Validator.isNotNull(this.localizedPortletTitleMap.get(locale))) {
                portletTitle = this.localizedPortletTitleMap.get(locale);
            } else {
                Locale defaultLocale = LocaleUtil.getDefault();
                if (Validator.isNotNull(this.localizedPortletTitleMap.get(defaultLocale))) {
                    portletTitle = this.localizedPortletTitleMap.get(defaultLocale);
                }
            }
        }
        if (Validator.isNotNull(portletTitle)) {
            content = StringUtil.replace(content, "[$PORTLET_TITLE$]", portletTitle);
        }
        Company company = CompanyLocalServiceUtil.getCompany(this.companyId);
        content = StringUtil.replace(content, new String[]{"href=\"/", "src=\"/"}, new String[]{"href=\"" + company.getPortalURL(this.groupId) + "/", "src=\"" + company.getPortalURL(this.groupId) + "/"});
        return content;
    }

    protected void sendEmail(InternetAddress to, Locale locale) throws Exception {
        InternetAddress from = new InternetAddress(this.replaceContent(this.fromAddress, locale), this.replaceContent(this.fromName, locale));
        String processedSubject = null;
        if (this.localizedSubjectMap != null) {
            String localizedSubject = this.localizedSubjectMap.get(locale);
            if (Validator.isNull(localizedSubject)) {
                Locale defaultLocale = LocaleUtil.getDefault();
                processedSubject = this.localizedSubjectMap.get(defaultLocale);
            } else {
                processedSubject = localizedSubject;
            }
        } else {
            processedSubject = this.subject;
        }
        String processedBody = null;
        if (this.localizedBodyMap != null) {
            String localizedBody = this.localizedBodyMap.get(locale);
            if (Validator.isNull(localizedBody)) {
                Locale defaultLocale = LocaleUtil.getDefault();
                processedBody = this.localizedBodyMap.get(defaultLocale);
            } else {
                processedBody = localizedBody;
            }
        } else {
            processedBody = this.body;
        }
        MailMessage mailMessage = new MailMessage(from, to, processedSubject, processedBody, this.htmlFormat);
        if (this.fileAttachments != null) {
            for (FileAttachment fileAttachment : this.fileAttachments) {
                mailMessage.addFileAttachment(fileAttachment.getFile(), fileAttachment.getFileName());
            }
        }
        if (this.bulk && this._bulkAddresses != null) {
            mailMessage.setBulkAddresses(this._bulkAddresses.toArray(new InternetAddress[this._bulkAddresses.size()]));
            this._bulkAddresses.clear();
        }
        if (this.inReplyTo != null) {
            mailMessage.setInReplyTo(this.inReplyTo);
        }
        mailMessage.setMessageId(this.mailId);
        if (this.replyToAddress != null) {
            InternetAddress replyTo = new InternetAddress(this.replaceContent(this.replyToAddress, locale), this.replaceContent(this.replyToAddress, locale));
            mailMessage.setReplyTo(new InternetAddress[]{replyTo});
        }
        if (this.smtpAccount != null) {
            mailMessage.setSMTPAccount(this.smtpAccount);
        }
        this.processMailMessage(mailMessage, locale);
        MailServiceUtil.sendEmail(mailMessage);
    }

    protected void sendEmailNotification(User user) throws Exception {
        if (UserNotificationManagerUtil.isDeliver(user.getUserId(), this.portletId, this._notificationClassNameId, this._notificationType, 10000)) {
            InternetAddress to = new InternetAddress(user.getEmailAddress(), user.getFullName());
            if (this.bulk) {
                if (this._bulkAddresses == null) {
                    this._bulkAddresses = new ArrayList<InternetAddress>();
                }
                this._bulkAddresses.add(to);
                return;
            }
            this.sendEmail(to, user.getLocale());
        }
    }

    protected void sendNotification(User user) throws Exception {
        if (this.currentUserId == user.getUserId()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip user " + this.currentUserId);
            }
            return;
        }
        this.sendEmailNotification(user);
        this.sendUserNotification(user);
    }

    protected void sendUserNotification(User user) throws Exception {
        JSONObject notificationEventJSONObject = JSONFactoryUtil.createJSONObject();
        notificationEventJSONObject.put("className", this._className);
        notificationEventJSONObject.put("classPK", this._classPK);
        notificationEventJSONObject.put("entryTitle", this._entryTitle);
        notificationEventJSONObject.put("entryURL", this._entryURL);
        notificationEventJSONObject.put("notificationType", this._notificationType);
        notificationEventJSONObject.put("userId", this.currentUserId);
        if (UserNotificationManagerUtil.isDeliver(user.getUserId(), this.portletId, this._notificationClassNameId, this._notificationType, 10005)) {
            UserNotificationEventLocalServiceUtil.sendUserNotificationEvents(user.getUserId(), this.portletId, 10005, notificationEventJSONObject);
        }
        if (UserNotificationManagerUtil.isDeliver(user.getUserId(), this.portletId, this._notificationClassNameId, this._notificationType, 10002)) {
            UserNotificationEventLocalServiceUtil.sendUserNotificationEvents(user.getUserId(), this.portletId, 10002, notificationEventJSONObject);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String servletContextName = objectInputStream.readUTF();
        if (!servletContextName.isEmpty()) {
            this._classLoader = ClassLoaderPool.getClassLoader(servletContextName);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        String servletContextName = "";
        if (this._classLoader != null) {
            servletContextName = ClassLoaderPool.getContextName(this._classLoader);
        }
        objectOutputStream.writeUTF(servletContextName);
    }
}

