/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.StringEncoder;
import com.liferay.portal.kernel.util.StringParserFragment;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    private static final Pattern _escapeRegexPattern = Pattern.compile("[\\{\\}\\(\\)\\[\\]\\*\\+\\?\\$\\^\\.\\#\\\\]");
    private static final Pattern _fragmentPattern = Pattern.compile("\\{.+?\\}");
    private static final Map<String, StringParser> _stringParserFragmentsCache = new ConcurrentReferenceValueHashMap<String, StringParser>(FinalizeManager.SOFT_REFERENCE_FACTORY);
    private final String _builder;
    private final Pattern _pattern;
    private StringEncoder _stringEncoder;
    private final List<StringParserFragment> _stringParserFragments;

    public static StringParser create(String chunk) {
        StringParser stringParser = _stringParserFragmentsCache.get(chunk);
        if (stringParser == null) {
            stringParser = new StringParser(chunk);
            _stringParserFragmentsCache.put(chunk, stringParser);
        }
        return stringParser;
    }

    public static String escapeRegex(String s) {
        Matcher matcher = _escapeRegexPattern.matcher(s);
        return matcher.replaceAll("\\\\$0");
    }

    public String build(Map<String, String> parameters) {
        String s = this._builder;
        for (StringParserFragment stringParserFragment : this._stringParserFragments) {
            String value = parameters.get(stringParserFragment.getName());
            if (value == null) {
                return null;
            }
            if (this._stringEncoder != null && !stringParserFragment.isRaw()) {
                value = this._stringEncoder.encode(value);
            }
            if (!stringParserFragment.matches(value)) {
                return null;
            }
            s = StringUtil.replace(s, stringParserFragment.getToken(), value);
        }
        for (StringParserFragment stringParserFragment : this._stringParserFragments) {
            parameters.remove(stringParserFragment.getName());
        }
        return s;
    }

    public boolean parse(String s, Map<String, String> parameters) {
        Matcher matcher = this._pattern.matcher(s);
        if (!matcher.matches()) {
            return false;
        }
        for (int i = 1; i <= this._stringParserFragments.size(); ++i) {
            StringParserFragment stringParserFragment = this._stringParserFragments.get(i - 1);
            String value = matcher.group(i);
            if (this._stringEncoder != null && !stringParserFragment.isRaw()) {
                value = this._stringEncoder.decode(value);
            }
            parameters.put(stringParserFragment.getName(), value);
        }
        return true;
    }

    public void setStringEncoder(StringEncoder stringEncoder) {
        this._stringEncoder = stringEncoder;
    }

    protected StringParser(String pattern) {
        String regex = StringParser.escapeRegex(pattern);
        Matcher matcher = _fragmentPattern.matcher(pattern);
        this._stringParserFragments = new ArrayList<StringParserFragment>(matcher.groupCount());
        while (matcher.find()) {
            String chunk = matcher.group();
            StringParserFragment stringParserFragment = StringParserFragment.create(chunk);
            this._stringParserFragments.add(stringParserFragment);
            pattern = StringUtil.replace(pattern, chunk, stringParserFragment.getToken());
            regex = StringUtil.replace(regex, StringParser.escapeRegex(chunk), "(".concat(stringParserFragment.getPattern().concat(")")));
        }
        this._builder = pattern;
        this._pattern = Pattern.compile(regex);
    }
}

