/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.SettingsLocatorHelperUtil;

public class GroupServiceSettingsLocator
implements SettingsLocator {
    private final String _configurationPid;
    private final long _groupId;
    private final String _settingsId;
    private final SettingsLocatorHelper _settingsLocatorHelper = SettingsLocatorHelperUtil.getSettingsLocatorHelper();

    public GroupServiceSettingsLocator(long groupId, String settingsId) {
        this._groupId = groupId;
        this._settingsId = settingsId;
        this._configurationPid = settingsId;
    }

    public GroupServiceSettingsLocator(long groupId, String settingsId, String configurationPid) {
        this._groupId = groupId;
        this._settingsId = settingsId;
        this._configurationPid = configurationPid;
    }

    @Override
    public Settings getSettings() throws SettingsException {
        long companyId = this.getCompanyId(this._groupId);
        Settings portalPropertiesSettings = this._settingsLocatorHelper.getPortalPropertiesSettings();
        Settings configurationBeanSettings = this._settingsLocatorHelper.getConfigurationBeanSettings(this._configurationPid, portalPropertiesSettings);
        Settings portalPreferencesSettings = this._settingsLocatorHelper.getPortalPreferencesSettings(companyId, configurationBeanSettings);
        Settings companyPortletPreferencesSettings = this._settingsLocatorHelper.getCompanyPortletPreferencesSettings(companyId, this._settingsId, portalPreferencesSettings);
        return this._settingsLocatorHelper.getGroupPortletPreferencesSettings(this._groupId, this._settingsId, companyPortletPreferencesSettings);
    }

    @Override
    public String getSettingsId() {
        return this._settingsId;
    }

    protected long getCompanyId(long groupId) throws SettingsException {
        try {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            return group.getCompanyId();
        }
        catch (PortalException pe) {
            throw new SettingsException(pe);
        }
    }
}

