/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.compoundsessionid;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;

public class CompoundSessionIdSplitterUtil {
    private static final boolean _HAS_SESSION_DELIMITER;
    private static final String _SESSION_ID_DELIMITER;

    public static String getSessionIdDelimiter() {
        return _SESSION_ID_DELIMITER;
    }

    public static boolean hasSessionDelimiter() {
        return _HAS_SESSION_DELIMITER;
    }

    public static String parseSessionId(String sessionId) {
        if (!_HAS_SESSION_DELIMITER) {
            return sessionId;
        }
        int pos = sessionId.indexOf(_SESSION_ID_DELIMITER);
        if (pos == -1) {
            return sessionId;
        }
        return sessionId.substring(0, pos);
    }

    static {
        String sessionIdDelimiter = PropsUtil.get("session.id.delimiter");
        if (Validator.isNull(sessionIdDelimiter)) {
            sessionIdDelimiter = PropsUtil.get("session.id." + ServerDetector.getServerId() + ".delimiter");
        }
        if (Validator.isNotNull(sessionIdDelimiter)) {
            _HAS_SESSION_DELIMITER = true;
            _SESSION_ID_DELIMITER = sessionIdDelimiter;
        } else {
            _HAS_SESSION_DELIMITER = false;
            _SESSION_ID_DELIMITER = "";
        }
    }
}

