/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.pacl.permission;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;

public class PortalSocketPermission {
    private static final PACL _pacl = new NoPACL();

    public static void checkConnect(Http.Options options) {
        PortalSocketPermission.checkConnect(options.getLocation());
    }

    public static void checkConnect(String location) {
        String domainAndPort = HttpUtil.getDomain(location);
        String[] domainAndPortArray = domainAndPort.split(":");
        String domain = domainAndPortArray[0];
        int port = -1;
        if (domainAndPortArray.length > 1) {
            port = GetterUtil.getInteger(domainAndPortArray[1]);
        }
        String protocol = HttpUtil.getProtocol(location);
        PortalSocketPermission.checkConnect(domain, port, protocol);
    }

    public static void checkConnect(URL url) {
        if (url == null) {
            return;
        }
        String domain = url.getHost();
        int port = url.getPort();
        String protocol = url.getProtocol();
        PortalSocketPermission.checkConnect(domain, port, protocol);
    }

    private static void checkConnect(String domain, int port, String protocol) {
        if (Validator.isNull(domain) || !protocol.startsWith("https") && !protocol.startsWith("http")) {
            return;
        }
        if (port == -1) {
            if ((protocol = StringUtil.toLowerCase(protocol)).startsWith("https")) {
                port = 443;
            } else if (protocol.startsWith("http")) {
                port = 80;
            }
        }
        String location = domain.concat(":").concat(String.valueOf(port));
        _pacl.checkPermission(location, "connect");
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public void checkPermission(String host, String action) {
        }
    }

    public static interface PACL {
        public void checkPermission(String var1, String var2);
    }
}

