/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.membershippolicy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import java.util.ArrayList;
import java.util.List;

public class MembershipPolicyException
extends PortalException {
    public static final int ORGANIZATION_MEMBERSHIP_NOT_ALLOWED = 1;
    public static final int ORGANIZATION_MEMBERSHIP_REQUIRED = 2;
    public static final int ROLE_MEMBERSHIP_NOT_ALLOWED = 3;
    public static final int ROLE_MEMBERSHIP_REQUIRED = 4;
    public static final int SITE_MEMBERSHIP_NOT_ALLOWED = 5;
    public static final int SITE_MEMBERSHIP_REQUIRED = 6;
    public static final int USER_GROUP_MEMBERSHIP_NOT_ALLOWED = 7;
    public static final int USER_GROUP_MEMBERSHIP_REQUIRED = 8;
    private final List<Group> _groups = new ArrayList<Group>();
    private final List<Organization> _organizations = new ArrayList<Organization>();
    private final List<Role> _roles = new ArrayList<Role>();
    private final int _type;
    private final List<UserGroup> _userGroups = new ArrayList<UserGroup>();
    private final List<User> _users = new ArrayList<User>();

    public MembershipPolicyException(int type) {
        this._type = type;
    }

    public void addGroup(Group group) {
        this._groups.add(group);
    }

    public void addOrganization(Organization organization) {
        this._organizations.add(organization);
    }

    public void addRole(Role role) {
        this._roles.add(role);
    }

    public void addUser(User user) {
        this._users.add(user);
    }

    public void addUserGroup(UserGroup userGroup) {
        this._userGroups.add(userGroup);
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public List<Organization> getOrganizations() {
        return this._organizations;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    public int getType() {
        return this._type;
    }

    public List<UserGroup> getUserGroups() {
        return this._userGroups;
    }

    public List<User> getUsers() {
        return this._users;
    }
}

