/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auto.login;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseAutoLogin
implements AutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(BaseAutoLogin.class);

    @Override
    public String[] handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws AutoLoginException {
        return this.doHandleException(request, response, e);
    }

    @Override
    public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
        try {
            return this.doLogin(request, response);
        }
        catch (Exception e) {
            return this.handleException(request, response, e);
        }
    }

    protected void addRedirect(HttpServletRequest request) {
        String redirect = ParamUtil.getString(request, "redirect");
        if (Validator.isNotNull(redirect)) {
            request.setAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE", (Object)PortalUtil.escapeRedirect(redirect));
        }
    }

    protected String[] doHandleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws AutoLoginException {
        if (request.getAttribute("AUTO_LOGIN_REDIRECT") == null) {
            throw new AutoLoginException(e);
        }
        _log.error(e, e);
        return null;
    }

    protected abstract String[] doLogin(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

