/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.local;

import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import java.io.Serializable;

public class AsyncBrokerThreadLocal {
    private static final ThreadLocal<AsyncBroker<Long, Serializable>> _asyncBrokerThreadLocal = new CentralizedThreadLocal<AsyncBroker<Long, Serializable>>(false);

    public static AsyncBroker<Long, Serializable> getAsyncBroker() {
        AsyncBroker<Long, Serializable> asyncBroker = _asyncBrokerThreadLocal.get();
        if (asyncBroker == null) {
            throw new IllegalStateException("Async broker is not set");
        }
        return asyncBroker;
    }

    public static void removeAsyncBroker() {
        _asyncBrokerThreadLocal.remove();
    }

    public static void setAsyncBroker(AsyncBroker<Long, Serializable> asyncBroker) {
        _asyncBrokerThreadLocal.set(asyncBroker);
    }
}

