/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.io.PathHolder;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ProcessConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> _arguments;
    private final PathHolder[] _bootstrapClassPathHolders;
    private final String _javaExecutable;
    private final transient ClassLoader _reactClassLoader;
    private final PathHolder[] _runtimeClassPathHolders;

    public List<String> getArguments() {
        return this._arguments;
    }

    public String getBootstrapClassPath() {
        return StringUtil.merge(this.getBootstrapClassPathElements(), File.pathSeparator);
    }

    public String[] getBootstrapClassPathElements() {
        return ArrayUtil.toStringArray(this._bootstrapClassPathHolders);
    }

    public String getJavaExecutable() {
        return this._javaExecutable;
    }

    public ClassLoader getReactClassLoader() {
        return this._reactClassLoader;
    }

    public String getRuntimeClassPath() {
        return StringUtil.merge(this.getRuntimeClassPathElements(), File.pathSeparator);
    }

    public String[] getRuntimeClassPathElements() {
        return ArrayUtil.toStringArray(this._runtimeClassPathHolders);
    }

    private ProcessConfig(Builder builder) {
        this._arguments = builder._arguments;
        this._bootstrapClassPathHolders = this.toPathHolders(builder._bootstrapClassPath);
        this._javaExecutable = builder._javaExecutable;
        this._reactClassLoader = builder._reactClassLoader;
        this._runtimeClassPathHolders = this.toPathHolders(builder._runtimeClassPath);
    }

    private PathHolder[] toPathHolders(String classPath) {
        String[] classPathElements = StringUtil.split(classPath, File.pathSeparatorChar);
        PathHolder[] classPathHolders = new PathHolder[classPathElements.length];
        for (int i = 0; i < classPathElements.length; ++i) {
            classPathHolders[i] = new PathHolder(classPathElements[i]);
        }
        return classPathHolders;
    }

    public static class Builder {
        private List<String> _arguments = Collections.emptyList();
        private String _bootstrapClassPath = System.getProperty("java.class.path");
        private String _javaExecutable = "java";
        private ClassLoader _reactClassLoader = ProcessConfig.class.getClassLoader();
        private String _runtimeClassPath = this._bootstrapClassPath;

        public ProcessConfig build() {
            return new ProcessConfig(this);
        }

        public Builder setArguments(List<String> arguments) {
            this._arguments = arguments;
            return this;
        }

        public Builder setBootstrapClassPath(String bootstrapClassPath) {
            this._bootstrapClassPath = bootstrapClassPath;
            return this;
        }

        public Builder setJavaExecutable(String javaExecutable) {
            this._javaExecutable = javaExecutable;
            return this;
        }

        public Builder setReactClassLoader(ClassLoader reactClassLoader) {
            this._reactClassLoader = reactClassLoader;
            return this;
        }

        public Builder setRuntimeClassPath(String runtimeClassPath) {
            this._runtimeClassPath = runtimeClassPath;
            return this;
        }
    }
}

