/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ProviderType
public class FriendlyURLResolverRegistryUtil {
    private static final FriendlyURLResolverRegistryUtil _instance = new FriendlyURLResolverRegistryUtil();
    private final Map<String, FriendlyURLResolver> _friendlyURLResolvers = new ConcurrentHashMap<String, FriendlyURLResolver>();
    private final ServiceRegistrationMap<FriendlyURLResolver> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTracker<FriendlyURLResolver, FriendlyURLResolver> _serviceTracker;

    public static FriendlyURLResolver getFriendlyURLResolver(String urlSeparator) {
        return _instance._getFriendlyURLResolver(urlSeparator);
    }

    public static List<FriendlyURLResolver> getFriendlyURLResolvers() {
        return _instance._getFriendlyURLResolvers();
    }

    public static String[] getURLSeparators() {
        return _instance._getURLSeparators();
    }

    public static void register(FriendlyURLResolver friendlyURLResolver) {
        _instance._register(friendlyURLResolver);
    }

    public static void unregister(FriendlyURLResolver friendlyURLResolver) {
        _instance._unregister(friendlyURLResolver);
    }

    private FriendlyURLResolverRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(FriendlyURLResolver.class, (ServiceTrackerCustomizer)new FriendlyURLResolverServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private FriendlyURLResolver _getFriendlyURLResolver(String urlSeparator) {
        return this._friendlyURLResolvers.get(urlSeparator);
    }

    private List<FriendlyURLResolver> _getFriendlyURLResolvers() {
        return ListUtil.fromMapValues(this._friendlyURLResolvers);
    }

    private String[] _getURLSeparators() {
        Set<String> urlSeparators = this._friendlyURLResolvers.keySet();
        return urlSeparators.toArray(new String[urlSeparators.size()]);
    }

    private void _register(FriendlyURLResolver friendlyURLResolver) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(FriendlyURLResolver.class, (Object)friendlyURLResolver);
        this._serviceRegistrations.put((Object)friendlyURLResolver, (Object)serviceRegistration);
    }

    private void _unregister(FriendlyURLResolver friendlyURLResolver) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)friendlyURLResolver);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class FriendlyURLResolverServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FriendlyURLResolver, FriendlyURLResolver> {
        private FriendlyURLResolverServiceTrackerCustomizer() {
        }

        public FriendlyURLResolver addingService(ServiceReference<FriendlyURLResolver> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)registry.getService(serviceReference);
            FriendlyURLResolverRegistryUtil.this._friendlyURLResolvers.put(friendlyURLResolver.getURLSeparator(), friendlyURLResolver);
            return friendlyURLResolver;
        }

        public void modifiedService(ServiceReference<FriendlyURLResolver> serviceReference, FriendlyURLResolver friendlyURLResolver) {
        }

        public void removedService(ServiceReference<FriendlyURLResolver> serviceReference, FriendlyURLResolver friendlyURLResolver) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            FriendlyURLResolverRegistryUtil.this._friendlyURLResolvers.remove(friendlyURLResolver.getURLSeparator());
        }
    }
}

