/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSenderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;

public class IndexableActionableDynamicQuery
extends DefaultActionableDynamicQuery {
    private static final long _STATUS_INTERVAL = 1000L;
    private long _count;
    private Collection<Document> _documents;
    private String _searchEngineId;
    private long _total;

    public void addDocuments(Document ... documents) throws PortalException {
        if (ArrayUtil.isEmpty(documents)) {
            return;
        }
        if (this._documents == null) {
            this._documents = this.isParallel() ? new ConcurrentLinkedDeque<Document>() : new ArrayList<Document>();
        }
        for (Document document : documents) {
            if (document == null) continue;
            this._documents.add(document);
        }
        long size = this._documents.size();
        if (size >= (long)this.getInterval()) {
            this.indexInterval();
        } else if (size % 1000L == 0L) {
            this.sendStatusMessage(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performActions() throws PortalException {
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            this._total = super.performCount();
        }
        try {
            super.performActions();
        }
        finally {
            this._count = this._total;
            this.sendStatusMessage();
        }
    }

    public void setSearchEngineId(String searchEngineId) {
        this._searchEngineId = searchEngineId;
    }

    @Override
    protected void actionsCompleted() throws PortalException {
        if (Validator.isNotNull(this._searchEngineId)) {
            IndexWriterHelperUtil.commit(this._searchEngineId, this.getCompanyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doPerformActions(long previousPrimaryKey) throws PortalException {
        try {
            long l = super.doPerformActions(previousPrimaryKey);
            return l;
        }
        finally {
            this.indexInterval();
        }
    }

    protected String getSearchEngineId() {
        return this._searchEngineId;
    }

    protected void indexInterval() throws PortalException {
        if (this._documents == null || this._documents.isEmpty()) {
            return;
        }
        if (Validator.isNull(this._searchEngineId)) {
            this._searchEngineId = SearchEngineHelperUtil.getSearchEngineId(this._documents);
        }
        IndexWriterHelperUtil.updateDocuments(this._searchEngineId, this.getCompanyId(), new ArrayList<Document>(this._documents), false);
        this._count += (long)this._documents.size();
        this._documents.clear();
        this.sendStatusMessage();
    }

    protected void sendStatusMessage() {
        this.sendStatusMessage(0L);
    }

    protected void sendStatusMessage(long documentIntervalCount) {
        if (!BackgroundTaskThreadLocal.hasBackgroundTask()) {
            return;
        }
        Class<?> modelClass = this.getModelClass();
        ReindexStatusMessageSenderUtil.sendStatusMessage(modelClass.getName(), this._count + documentIntervalCount, this._total);
    }
}

