/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.sync.internal.model.listener.SyncBaseModelListener;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.SyncDeviceLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends SyncBaseModelListener<User> {
    @Reference
    private SyncDeviceLocalService _syncDeviceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterRemove(User user) throws ModelListenerException {
        try {
            if (user != null) {
                List syncDevices = this._syncDeviceLocalService.getSyncDevices(user.getUserId(), -1, -1, null);
                for (SyncDevice syncDevice : syncDevices) {
                    this._syncDeviceLocalService.deleteSyncDevice(syncDevice);
                }
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (associationClassName.equals(Role.class.getName())) {
            User user = this._userLocalService.fetchUser(((Long)classPK).longValue());
            if (user == null || !user.isActive()) {
                return;
            }
            this.onAddRoleAssociation(associationClassPK);
        }
    }

    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (associationClassName.equals(Role.class.getName())) {
            User user = this._userLocalService.fetchUser(((Long)classPK).longValue());
            if (user == null || !user.isActive()) {
                return;
            }
            this.onRemoveRoleAssociation(associationClassPK);
        }
    }

    public void onBeforeUpdate(User user) throws ModelListenerException {
        try {
            User originalUser = this._userLocalService.getUser(user.getUserId());
            if (originalUser.isActive() && !user.isActive()) {
                List syncDevices = this._syncDeviceLocalService.getSyncDevices(user.getUserId(), -1, -1, null);
                for (SyncDevice syncDevice : syncDevices) {
                    this._syncDeviceLocalService.updateStatus(syncDevice.getSyncDeviceId(), 1);
                }
            } else if (!originalUser.isActive() && user.isActive()) {
                List syncDevices = this._syncDeviceLocalService.getSyncDevices(user.getUserId(), -1, -1, null);
                for (SyncDevice syncDevice : syncDevices) {
                    this._syncDeviceLocalService.updateStatus(syncDevice.getSyncDeviceId(), 0);
                }
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

