/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (associationClassName.equals(Organization.class.getName())) {
            Organization organization = this._organizationLocalService.fetchOrganization(((Long)associationClassPK).longValue());
            associationClassPK = organization.getGroupId();
        }
        try {
            this._subscriptionLocalService.deleteSubscriptions(((Long)classPK).longValue(), ((Long)associationClassPK).longValue());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeRemove(User user) {
        try {
            this._subscriptionLocalService.deleteSubscriptions(user.getUserId());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

