/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.internal.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.SubscriptionSender;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"destination.name=liferay/subscription_sender"}, service={MessageListener.class})
public class SubscriptionSenderMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(SubscriptionSenderMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        SubscriptionSender subscriptionSender = (SubscriptionSender)message.getPayload();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sending notifications for {mailId=" + subscriptionSender.getMailId() + "}"));
        }
        subscriptionSender.flushNotifications();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Sending notifications for {mailId=", subscriptionSender.getMailId(), "} completed in ", stopWatch.getTime() / 1000L, " seconds"}));
        }
    }
}

