/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Locale;

@StatelessCheck
public class MethodParamPadCheck
extends AbstractCheck {
    public static final String MSG_LINE_PREVIOUS = "line.previous";
    public static final String MSG_WS_PRECEDED = "ws.preceded";
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    private boolean allowLineBreaks;
    private PadOption option = PadOption.NOSPACE;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 136, 27, 9, 42, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST parenAST = ast.getType() == 27 ? ast : ast.findFirstToken(76);
        if (parenAST != null) {
            String line = this.getLines()[parenAST.getLineNo() - 1];
            if (CommonUtil.hasWhitespaceBefore(parenAST.getColumnNo(), line)) {
                if (!this.allowLineBreaks) {
                    this.log(parenAST, MSG_LINE_PREVIOUS, parenAST.getText());
                }
            } else {
                int before = parenAST.getColumnNo() - 1;
                if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(before))) {
                    this.log(parenAST, MSG_WS_PRECEDED, parenAST.getText());
                } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(before))) {
                    this.log(parenAST, MSG_WS_NOT_PRECEDED, parenAST.getText());
                }
            }
        }
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }

    public void setOption(String optionStr) {
        try {
            this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("unable to parse " + optionStr, iae);
        }
    }
}

