/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.StringConcatenationCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class ConcatCheck
extends StringConcatenationCheck {
    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getMethodCalls(detailAST, "StringBundler", "concat");
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            this._checkConcatMethodCall(methodCallDetailAST);
        }
    }

    private void _checkConcatMethodCall(DetailAST methodCallDetailAST) {
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        DetailAST previousLiteralStringDetailAST = null;
        for (DetailAST childDetailAST = elistDetailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
            DetailAST literalStringDetailAST;
            if (childDetailAST.getType() != 28) continue;
            DetailAST grandChildDetailAST = childDetailAST.getFirstChild();
            if (grandChildDetailAST.getType() != 139) {
                previousLiteralStringDetailAST = null;
            } else {
                if (previousLiteralStringDetailAST != null) {
                    this._checkConcatMethodCallLiteralStrings(previousLiteralStringDetailAST, grandChildDetailAST);
                }
                previousLiteralStringDetailAST = grandChildDetailAST;
            }
            if (grandChildDetailAST.getType() != 125 || (literalStringDetailAST = grandChildDetailAST.findFirstToken(139)) == null) continue;
            this.log(grandChildDetailAST, "plus.incorrect", new Object[0]);
        }
    }

    private void _checkConcatMethodCallLiteralStrings(DetailAST literalStringDetailAST1, DetailAST literalStringDetailAST2) {
        String literalStringValue1 = literalStringDetailAST1.getText();
        literalStringValue1 = literalStringValue1.substring(1, literalStringValue1.length() - 1);
        String literalStringValue2 = literalStringDetailAST2.getText();
        literalStringValue2 = literalStringValue2.substring(1, literalStringValue2.length() - 1);
        if (literalStringDetailAST1.getLineNo() == literalStringDetailAST2.getLineNo()) {
            if (!literalStringValue1.endsWith("\\n") || literalStringValue2.equals("\\n")) {
                this.log(literalStringDetailAST1, "literal.string.combine", new Object[]{literalStringValue1, literalStringValue2});
            }
            return;
        }
        this.checkLiteralStringStartAndEndCharacter(literalStringValue1, literalStringValue2, literalStringDetailAST1.getLineNo());
        String line = this.getLine(literalStringDetailAST1.getLineNo() - 1);
        int lineLength = CommonUtil.lengthExpandedTabs((String)line, (int)line.length(), (int)this.getTabWidth());
        int pos = this.getStringBreakPos(literalStringValue1, literalStringValue2, this.getMaxLineLength() - lineLength);
        if (pos != -1) {
            this.log(literalStringDetailAST2, "literal.string.move", new Object[]{literalStringValue2.substring(0, pos + 1)});
        }
    }
}

