/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.YMLSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLDefinitionOrderCheck
extends BaseFileCheck {
    private static final Map<String, Integer> _parameterTypesWeightMap = new HashMap<String, Integer>(){
        {
            this.put("cookie", 4);
            this.put("header", 3);
            this.put("path", 1);
            this.put("query", 2);
        }
    };
    private static final Pattern _pathPattern = Pattern.compile("(?<=\n)( *)\"([^{}\"]*\\{[^}]+\\}[^{}\"]*){2,}\":(\n\\1 .*)*");
    private static final Map<String, Integer> _specialQueriesKeyWeightMap = new HashMap<String, Integer>(){
        {
            this.put("filter", 1);
            this.put("page", 2);
            this.put("pageSize", 3);
            this.put("search", 4);
            this.put("sort", 5);
        }
    };

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith(".travis.yml")) {
            return content;
        }
        String[] ymlDefinitions = content.split("\n---\n");
        StringBundler sb = new StringBundler(ymlDefinitions.length * 2);
        for (String ymlDefinition : ymlDefinitions) {
            sb.append(this._sortDefinitions(fileName, ymlDefinition, ""));
            sb.append("\n---\n");
        }
        sb.setIndex(sb.index() - 1);
        content = this._sortPathParameters(sb.toString());
        return content;
    }

    private String _getParameterType(String definition) {
        return definition.replaceAll("(?s).*in: (\\S*).*", "$1");
    }

    private int _getParameterTypeWeight(String definitionKey) {
        if (_parameterTypesWeightMap.containsKey(definitionKey)) {
            return _parameterTypesWeightMap.get(definitionKey);
        }
        return -1;
    }

    private int _getSpecialQueryKeyWeight(String definitionKey) {
        if (_specialQueriesKeyWeightMap.containsKey(definitionKey)) {
            return _specialQueriesKeyWeightMap.get(definitionKey);
        }
        return -1;
    }

    private List<String> _removeDuplicateAttribute(List<String> list) {
        ArrayList<String> definitions = new ArrayList<String>();
        for (String s : list) {
            if (definitions.contains(s) && !s.startsWith("{{") && !s.startsWith("#")) continue;
            definitions.add(s);
        }
        return definitions;
    }

    private String _sortDefinitions(String fileName, String content, String indent) {
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        if (definitions.size() == 1 && !content.contains("\n")) {
            return content;
        }
        ArrayList<String> oldDefinitions = new ArrayList<String>(definitions);
        definitions = this._removeDuplicateAttribute(definitions);
        Collections.sort(definitions, new Comparator<String>(){

            @Override
            public int compare(String definition1, String definition2) {
                String trimmedDefinition1 = StringUtil.trimLeading(definition1);
                String trimmedDefinition2 = StringUtil.trimLeading(definition2);
                if (trimmedDefinition1.startsWith("{{") || trimmedDefinition2.startsWith("{{") || Validator.isNull(trimmedDefinition1) || Validator.isNull(trimmedDefinition2)) {
                    return 0;
                }
                String[] definition1Lines = StringUtil.splitLines(definition1);
                String[] definition2Lines = StringUtil.splitLines(definition2);
                String trimmedDefinition1Line = definition1Lines[0];
                String trimmedDefinition2Line = definition2Lines[0];
                if (trimmedDefinition1Line.startsWith("#") || trimmedDefinition2Line.startsWith("#")) {
                    return 0;
                }
                if (trimmedDefinition1Line.equals("-") && trimmedDefinition2Line.equals("-")) {
                    if (definition1Lines[1].contains("in: ") && definition2Lines[1].contains("in: ")) {
                        return YMLDefinitionOrderCheck.this._sortSpecificDefinitions(definition1, definition2, "name");
                    }
                    String value1 = definition1Lines[1].trim();
                    String value2 = definition2Lines[1].trim();
                    return value1.compareTo(value2);
                }
                if (trimmedDefinition1Line.startsWith("in:") || trimmedDefinition2Line.startsWith("in:")) {
                    if (trimmedDefinition1Line.startsWith("in:")) {
                        return -1;
                    }
                    return 1;
                }
                return trimmedDefinition1Line.compareTo(trimmedDefinition2Line);
            }
        });
        if (!oldDefinitions.equals(definitions)) {
            StringBundler sb = new StringBundler();
            for (String definition : definitions) {
                sb.append(definition);
                sb.append("\n");
            }
            sb.setIndex(sb.index() - 1);
            String[] lines = content.split("\n");
            content = !indent.equals("") ? lines[0] + "\n" + sb.toString() : sb.toString();
        }
        definitions = YMLSourceUtil.getDefinitions(content, indent);
        for (String definition : definitions) {
            String nestedDefinitionIndent;
            String[] lines = StringUtil.splitLines(definition);
            if (lines.length != 0 && lines[0].matches(" *(description:|.+: +.+)") || (nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition)).equals("")) continue;
            content = StringUtil.replaceFirst(content, definition, this._sortDefinitions(fileName, definition, nestedDefinitionIndent));
        }
        return content;
    }

    private String _sortPathParameters(String content) {
        Matcher matcher1 = _pathPattern.matcher(content);
        Pattern pattern = null;
        while (matcher1.find()) {
            String path = matcher1.group();
            pattern = Pattern.compile("\\{([^{}]+)\\}");
            Matcher matcher2 = pattern.matcher(path);
            LinkedHashMap<String, String> inPathsMap = new LinkedHashMap<String, String>();
            while (matcher2.find()) {
                inPathsMap.put(matcher2.group(1), "");
            }
            int inPathCount = inPathsMap.size();
            pattern = Pattern.compile("( *-\n( +)in: path(\n\\2.+)*\n){" + inPathCount + "}");
            matcher2 = pattern.matcher(path);
            while (matcher2.find()) {
                String inPaths = null;
                inPaths = matcher2.group();
                pattern = Pattern.compile(" *-\n( +)in: path(\n\\1.+)*\n");
                Matcher matcher3 = pattern.matcher(inPaths);
                while (matcher3.find()) {
                    String inPath = matcher3.group();
                    inPathsMap.replace(inPath.replaceAll("(?s).*name: (\\S+).*", "$1"), inPath);
                }
                StringBundler sb = new StringBundler(inPathCount);
                for (Map.Entry entry : inPathsMap.entrySet()) {
                    sb.append((String)entry.getValue());
                }
                content = StringUtil.replaceFirst(content, inPaths, sb.toString());
            }
        }
        return content;
    }

    private int _sortSpecificDefinitions(String definition1, String definition2, String key) {
        String parameter1Type = this._getParameterType(definition1);
        String parameter2Type = this._getParameterType(definition2);
        Pattern pattern = Pattern.compile("^ *" + key + ": *(\\S*)(\n|\\Z)", 8);
        String value1 = "";
        Matcher matcher = pattern.matcher(definition1);
        if (matcher.find()) {
            value1 = matcher.group(1);
        }
        String value2 = "";
        matcher = pattern.matcher(definition2);
        if (matcher.find()) {
            value2 = matcher.group(1);
        }
        if (parameter1Type.equals(parameter2Type)) {
            if (parameter1Type.equals("query")) {
                int weight1 = this._getSpecialQueryKeyWeight(value1);
                int weight2 = this._getSpecialQueryKeyWeight(value2);
                if (weight1 != -1 || weight2 != -1) {
                    return weight1 - weight2;
                }
            }
            return value1.compareTo(value2);
        }
        return this._getParameterTypeWeight(parameter1Type) - this._getParameterTypeWeight(parameter2Type);
    }
}

