/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class NewFileCheck
extends BaseFileCheck {
    private static final String _FORBIDDEN_DIR_NAMES_KEY = "forbiddenDirNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return false;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> forbiddenDirNames = this.getAttributeValues(_FORBIDDEN_DIR_NAMES_KEY, absolutePath);
        if (forbiddenDirNames.isEmpty()) {
            return content;
        }
        String portalBranchName = this.getAttributeValue("git.liferay.portal.branch", absolutePath);
        for (String forbiddenDirName : forbiddenDirNames) {
            int pos = absolutePath.indexOf(forbiddenDirName);
            if (pos == -1) continue;
            try {
                URL url = SourceFormatterUtil.getPortalGitURL(absolutePath.substring(pos), portalBranchName);
                url.openStream();
            }
            catch (FileNotFoundException fnfe) {
                this.addMessage(fileName, "Do not add new files to '" + forbiddenDirName + "'");
            }
            catch (IOException iOException) {}
        }
        return content;
    }
}

