/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JavaMultiPlusConcatCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath) || this.isModulesApp(absolutePath, true)) {
            return javaTerm.getContent();
        }
        this._checkConcat(fileName, absolutePath, javaTerm, fileContent);
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD, JAVA_VARIABLE};
    }

    private void _checkConcat(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        String javaTermContent = javaTerm.getContent();
        int x = -1;
        while ((x = javaTermContent.indexOf("+", x + 1)) != -1) {
            int endPos;
            int startPos;
            String line;
            char nextChar = javaTermContent.charAt(x + 1);
            if (nextChar == '+' || nextChar == '=') {
                ++x;
                continue;
            }
            if (ToolsUtil.isInsideQuotes(javaTermContent, x) || this._isInsideAnnotation(javaTermContent, x) || (line = StringUtil.trim(this.getLine(javaTermContent, this.getLineNumber(javaTermContent, x)))).startsWith("//") || line.startsWith("*") || (startPos = this._getStartPos(javaTermContent, x)) == -1 || (endPos = this._getEndPos(javaTermContent, startPos)) < x) continue;
            String plusStatement = javaTermContent.substring(startPos, endPos);
            List<String> parts = this._getParts(StringUtil.trim(plusStatement));
            if (parts.size() > 3 && this._containsStringVariable(fileContent, parts)) {
                if (absolutePath.contains("/modules/") && !absolutePath.contains("/modules/apps/") && !this._hasKernelOrPetraStringDependency(absolutePath)) {
                    return;
                }
                int pos = this.getLineNumber(javaTermContent, startPos);
                this.addMessage(fileName, "Use method 'StringBundler.concat' when concatenating more than 3 strings", "concat.markdown", javaTerm.getLineNumber() + pos - 1);
            }
            x = endPos;
        }
        return;
    }

    private boolean _containsStringVariable(String content, List<String> parts) {
        for (String part : parts) {
            if (!part.startsWith("\"") && !part.startsWith("CharPool.") && !part.startsWith("File.pathSeparator") && !part.startsWith("File.separator") && !part.startsWith("StringPool.") && (!Validator.isVariableName(part) || !content.matches("(?s).+\\sString\\s+" + part + "\\W.+"))) continue;
            return true;
        }
        return false;
    }

    private int _getEndPos(String content, int startPos) {
        char[] endChars = new char[]{'}', ')', ',', ';'};
        int i = startPos + 1;
        char c;
        while (!ArrayUtil.contains(endChars, c = content.charAt(i)) || ToolsUtil.isInsideQuotes(content, i) || this.getLevel(content.substring(startPos, i)) != 0) {
            ++i;
        }
        return i;
    }

    private List<String> _getParts(String plusStatement) {
        ArrayList<String> parts = new ArrayList<String>();
        int x = -1;
        while (true) {
            if (ToolsUtil.isInsideQuotes(plusStatement, x = plusStatement.indexOf(43, x + 1))) {
                continue;
            }
            if (x == -1) {
                parts.add(plusStatement);
                return parts;
            }
            if (plusStatement.charAt(x + 1) == '+') {
                ++x;
                continue;
            }
            String part = plusStatement.substring(0, x - 1);
            if (this.getLevel(part) != 0) continue;
            parts.add(part);
            plusStatement = StringUtil.trim(plusStatement.substring(x + 1));
            x = -1;
        }
    }

    private int _getStartPos(String content, int x) {
        char[] startChars = new char[]{'{', '(', ',', '='};
        int i = x;
        String s;
        char c;
        while (!ArrayUtil.contains(startChars, c = content.charAt(i)) && !Character.isWhitespace(c) || ToolsUtil.isInsideQuotes(content, i) || !Validator.isNotNull(s = content.substring(i + 1, x)) || this.getLevel(s) != 0) {
            --i;
        }
        return i + 1;
    }

    private boolean _hasKernelOrPetraStringDependency(String absolutePath) throws IOException {
        String buildGradleContent = this.getBuildGradleContent(absolutePath);
        return buildGradleContent != null && (buildGradleContent.contains("name: \"com.liferay.petra.string\"") || buildGradleContent.contains("name: \"com.liferay.portal.kernel\""));
    }

    private boolean _isInsideAnnotation(String content, int x) {
        int level;
        char c;
        int start = x;
        int end = -1;
        do {
            if ((start = content.lastIndexOf("@", start - 1)) != -1) continue;
            return false;
        } while ((c = content.charAt(start - 1)) != '\t' && c != '\n');
        int lineNumber = this.getLineNumber(content, start);
        String line = this.getLine(content, lineNumber);
        if (!line.contains("(")) {
            return false;
        }
        int posPar = content.indexOf("(", start);
        end = posPar + 1;
        String s = null;
        while ((level = this.getLevel(s = content.substring(start, end))) != 0) {
            ++end;
        }
        return start < x && x < end;
    }
}

