/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;
import java.util.Objects;

public class JSONUtilCheck
extends BaseCheck {
    private static final String _MSG_USE_JSON_UTIL_PUT = "json.util.put.use";
    private static final String _MSG_USE_JSON_UTIL_PUT_ALL = "json.util.put.all.use";

    public int[] getDefaultTokens() {
        return new int[]{80, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 27) {
            this._checkChainedPutCalls(detailAST);
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28 && parentDetailAST.getType() != 10) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        DetailAST methodCallDetailAST = this._getMethodCallDetailAST(detailAST, parentDetailAST);
        if (methodCallDetailAST == null) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() > 0) {
            return;
        }
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        String methodName = fullIdent.getText();
        if (!methodName.equals("JSONFactoryUtil.createJSONArray") && !methodName.equals("JSONFactoryUtil.createJSONObject")) {
            return;
        }
        String variableName = this._getVariableName(detailAST, parentDetailAST);
        if (variableName == null) {
            return;
        }
        do {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                return;
            }
            int lineNumber = this._getMethodCallLineNumber(nextSiblingDetailAST, variableName, "put");
            if (lineNumber == -1) continue;
            this.log(lineNumber, _MSG_USE_JSON_UTIL_PUT, new Object[]{methodName, fullIdent.getLineNo(), variableName + ".put", lineNumber, "JSONUtil.put"});
        } while (!this._containsVariableName(nextSiblingDetailAST, variableName));
    }

    private void _checkChainedPutCalls(DetailAST methodCallDetailAST) {
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        if (!Objects.equals(fullIdent.getText(), "JSONUtil.put")) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() != 1) {
            return;
        }
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 59) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 27) {
            return;
        }
        DetailAST nextSiblingDetailAST = methodCallDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() == 58 && Objects.equals(nextSiblingDetailAST.getText(), "put")) {
            this.log(methodCallDetailAST, _MSG_USE_JSON_UTIL_PUT_ALL, new Object[0]);
        }
    }

    private boolean _containsVariableName(DetailAST detailAST, String variableName) {
        List<DetailAST> identDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!variableName.equals(identDetailAST.getText())) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getMethodCallDetailAST(DetailAST assignDetailAST, DetailAST parentDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST != null && assignValueDetailAST.getType() == 27) {
            return assignValueDetailAST;
        }
        return null;
    }

    private int _getMethodCallLineNumber(DetailAST detailAST, String variableName, String methodName) {
        if (detailAST.getType() != 28) {
            return -1;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        while (firstChildDetailAST != null && firstChildDetailAST.getType() == 27) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)(firstChildDetailAST = firstChildDetailAST.getFirstChild()));
            if (Objects.equals(fullIdent.getText(), variableName + "." + methodName)) {
                return fullIdent.getLineNo();
            }
            if (firstChildDetailAST.getType() != 59) {
                return -1;
            }
            firstChildDetailAST = firstChildDetailAST.getFirstChild();
        }
        return -1;
    }

    private String _getVariableName(DetailAST assignDetailAST, DetailAST parentDetailAST) {
        if (parentDetailAST.getType() == 28) {
            DetailAST nameDetailAST = assignDetailAST.getFirstChild();
            if (nameDetailAST.getType() == 58) {
                return nameDetailAST.getText();
            }
            return null;
        }
        DetailAST nameDetailAST = parentDetailAST.findFirstToken(58);
        if (nameDetailAST != null) {
            return nameDetailAST.getText();
        }
        return null;
    }
}

