/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

public class CamelCaseNameCheck
extends BaseCheck {
    private static final String _MSG_METHOD_INVALID_NAME = "method.invalidName";
    private static final String _MSG_PARAMETER_INVALID_NAME = "parameter.invalidName";
    private static final String _MSG_VARIABLE_INVALID_NAME = "variable.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkName(detailAST, "re", "reCaptcha");
        this._checkName(detailAST, "sub", new String[0]);
    }

    private void _checkName(DetailAST detailAST, String s, String ... allowedNames) {
        String regex;
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        String lowerCaseName = StringUtil.toLowerCase(name);
        for (String allowedName : allowedNames) {
            if (!lowerCaseName.contains(StringUtil.toLowerCase(allowedName))) continue;
            return;
        }
        if (detailAST.getType() == 9) {
            if (!AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override") && name.matches(regex = StringBundler.concat("(^_", s, "|.*", TextFormatter.format(s, 6), ")[A-Z].*"))) {
                this.log(detailAST, _MSG_METHOD_INVALID_NAME, new Object[]{s, name});
            }
        } else {
            regex = StringBundler.concat("^_?", s, "[A-Z].*");
            if (name.matches(regex)) {
                if (detailAST.getType() == 21) {
                    this.log(detailAST, _MSG_PARAMETER_INVALID_NAME, new Object[]{s, name});
                } else {
                    this.log(detailAST, _MSG_VARIABLE_INVALID_NAME, new Object[]{s, name});
                }
            }
        }
    }
}

