/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WhitespaceCheck
extends BaseFileCheck {
    private static final String _ALLOW_LEADING_SPACES_KEY = "allowLeadingSpaces";
    private static final String _ALLOW_TRAILING_DOUBLE_SPACE_KEY = "allowTrailingDoubleSpace";
    private static final Pattern _selfClosingTagsPattern = Pattern.compile("<(area|base|br|col|command|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)(?!( />|\\w))");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._trimContent(fileName, absolutePath, content);
        if ((content = StringUtil.replace(content, "\n\n\n", "\n\n")).startsWith("\n")) {
            content = content.substring(1);
        }
        if (content.endsWith("\r")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String formatIncorrectSyntax(String line, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            int x = matcher.start(1);
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            return StringUtil.insert(line, " ", x);
        }
        return line;
    }

    protected String formatIncorrectSyntax(String line, String incorrectSyntax, String correctSyntax, boolean lineStart) {
        if (lineStart) {
            if (line.startsWith(incorrectSyntax)) {
                line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax);
            }
            return line;
        }
        int x = -1;
        while ((x = line.indexOf(incorrectSyntax, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax, x);
        }
        return line;
    }

    protected String formatSelfClosingTags(String line) {
        Matcher matcher = _selfClosingTagsPattern.matcher(line);
        block0: while (matcher.find()) {
            int level = 1;
            for (int x = matcher.end(); x < line.length(); ++x) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                char c = line.charAt(x);
                if (c == '<') {
                    ++level;
                } else if (c == '>') {
                    --level;
                }
                if (level != 0) continue;
                if (Objects.equals(line.substring(x - 2, x), " /")) continue block0;
                char previousChar = line.charAt(x - 1);
                if (previousChar == ' ') {
                    return StringUtil.insert(line, "/", x);
                }
                if (previousChar == '/') {
                    return StringUtil.insert(line, " ", x - 1);
                }
                return StringUtil.insert(line, " /", x);
            }
        }
        return line;
    }

    protected String formatWhitespace(String line, String linePart, boolean javaSource) {
        String linePart2;
        String originalLinePart = linePart;
        linePart = this.formatIncorrectSyntax(linePart, "catch(", "catch (", true);
        linePart = this.formatIncorrectSyntax(linePart, "else{", "else {", true);
        linePart = this.formatIncorrectSyntax(linePart, "else if(", "else if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "for(", "for (", true);
        linePart = this.formatIncorrectSyntax(linePart, "if(", "if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "while(", "while (", true);
        linePart = this.formatIncorrectSyntax(linePart, "List <", "List<", false);
        if (javaSource) {
            linePart = this.formatIncorrectSyntax(linePart, " ...", "...", false);
            linePart = this.formatIncorrectSyntax(linePart, " [", "[", false);
            linePart = this.formatIncorrectSyntax(linePart, "{ ", "{", false);
            linePart = this.formatIncorrectSyntax(linePart, " }", "}", false);
            linePart = this.formatIncorrectSyntax(linePart, " )", ")", false);
            linePart = this.formatIncorrectSyntax(linePart, "( ", "(", false);
            linePart = this.formatIncorrectSyntax(linePart, "){", ") {", false);
            linePart = this.formatIncorrectSyntax(linePart, "]{", "] {", false);
            linePart = this.formatIncorrectSyntax(linePart, "[^\"'\\s](\\|\\|)");
            linePart = this.formatIncorrectSyntax(linePart, "\\|\\|([^\"'\\s])");
            linePart = this.formatIncorrectSyntax(linePart, "[^\"'\\s](\\&\\&)");
            linePart = this.formatIncorrectSyntax(linePart, "\\&\\&([^\"'\\s])");
            linePart = this.formatIncorrectSyntax(linePart, "\\.\\.\\.(\\w)");
            linePart = this.formatIncorrectSyntax(linePart, "\\w(=)");
            linePart = this.formatIncorrectSyntax(linePart, "=(\\w)");
            linePart = this.formatIncorrectSyntax(linePart, "for \\([^:]*[^:\"'\\s](:)");
            linePart = this.formatIncorrectSyntax(linePart, "for \\([^:]*:([^:\"'\\s])");
        }
        if (!linePart.startsWith("##")) {
            int x = 0;
            while ((x = linePart.indexOf("  ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
                linePart = StringUtil.replaceFirst(linePart, "  ", " ", x);
            }
        }
        if (!javaSource) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        if (!line.contains("//")) {
            while (linePart.contains("\t")) {
                linePart = StringUtil.replaceLast(linePart, "\t", " ");
            }
        }
        if (line.contains("//")) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        int pos = linePart.indexOf(") ");
        if (!(pos == -1 || pos + 2 >= linePart.length() || linePart.contains("@") || ToolsUtil.isInsideQuotes(linePart, pos) || !Character.isLetter((linePart2 = linePart.substring(pos + 2)).charAt(0)) || linePart2.startsWith("default") || linePart2.startsWith("instanceof") || linePart2.startsWith("return") || linePart2.startsWith("throws"))) {
            linePart = StringUtil.replaceFirst(linePart, " ", "", pos);
        }
        if ((pos = linePart.indexOf(" (")) != -1 && !linePart.contains("=") && !ToolsUtil.isInsideQuotes(linePart, pos) && (linePart.startsWith("private ") || linePart.startsWith("protected ") || linePart.startsWith("public "))) {
            linePart = StringUtil.replaceFirst(linePart, " (", "(", pos);
        }
        int x = -1;
        while (true) {
            char previousChar;
            char nextChar;
            int posComma = linePart.indexOf(44, x + 1);
            int posSemicolon = linePart.indexOf(59, x + 1);
            if (posComma == -1 && posSemicolon == -1) break;
            x = Math.min(posComma, posSemicolon);
            if (x == -1) {
                x = Math.max(posComma, posSemicolon);
            }
            if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
            if (linePart.length() > x + 1 && (nextChar = linePart.charAt(x + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                linePart = StringUtil.insert(linePart, " ", x + 1);
            }
            if (x <= 0 || (previousChar = linePart.charAt(x - 1)) != ' ') continue;
            linePart = linePart.substring(0, x - 1) + linePart.substring(x);
        }
        line = StringUtil.replace(line, originalLinePart, linePart);
        return this.formatIncorrectSyntax(line, " \t", "\t", false);
    }

    protected boolean isAllowLeadingSpaces(String fileName, String absolutePath) {
        return this.isAttributeValue(_ALLOW_LEADING_SPACES_KEY, absolutePath);
    }

    protected boolean isAllowTrailingEmptyLines(String fileName) {
        return false;
    }

    protected boolean isAllowTrailingSpaces(String line) {
        return false;
    }

    protected String trimLine(String fileName, String absolutePath, String line) {
        String trimmedLine = StringUtil.trim(line);
        if (trimmedLine.length() == 0) {
            return "";
        }
        if (!(this.isAllowTrailingSpaces(line) || this.isAttributeValue(_ALLOW_TRAILING_DOUBLE_SPACE_KEY, absolutePath) && line.endsWith("  "))) {
            line = StringUtil.trimTrailing(line);
        }
        if (this.isAllowLeadingSpaces(fileName, absolutePath) || line.startsWith(" *")) {
            return line;
        }
        while (line.matches("^\t*    .*")) {
            line = StringUtil.replaceFirst(line, "    ", "\t");
        }
        while (line.startsWith(" ")) {
            line = StringUtil.replaceFirst(line, ' ', "");
        }
        return line;
    }

    private String _trimContent(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this.trimLine(fileName, absolutePath, line));
                sb.append("\n");
            }
        }
        if (this.isAllowTrailingEmptyLines(fileName) && content.endsWith("\n")) {
            return sb.toString();
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

