/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPUnusedTermsCheck
extends BaseFileCheck {
    private static final String[] _PORTLET_DEFINE_OBJECTS_PROPERTIES = new String[]{"actionRequest", "actionResponse", "eventRequest", "eventResponse", "liferayPortletRequest", "liferayPortletResponse", "portletConfig", "portletName", "portletPreferences", "portletPreferencesValues", "portletSession", "portletSessionScope", "renderResponse", "renderRequest", "resourceRequest", "resourceResponse"};
    private static final String _UNUSED_VARIABLES_EXCLUDES = "jsp.unused.variables.excludes";
    private static final Pattern _compressedJSPImportPattern = Pattern.compile("(<.*\n*(?:page|tag) import=\".*>\n*)+", 8);
    private static final Pattern _taglibURIPattern = Pattern.compile("<%@\\s+taglib uri=.* prefix=\"(.*?)\" %>");
    private List<String> _allFileNames;
    private Map<String, String> _contentsMap;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        Map<String, String> contentsMap = this._getContentsMap();
        if (contentsMap.isEmpty()) {
            this._contentsMap.put(fileName, content);
        }
        content = this._removeUnusedImports(fileName, content);
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ page import=");
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ tag import=");
        if (this.isPortalSource() || this.isSubrepository()) {
            content = this._removeUnusedPortletDefineObjects(fileName, content);
            content = this._removeUnusedTaglibs(fileName, content);
            content = this._removeUnusedVariables(fileName, absolutePath, content);
        }
        this._contentsMap.put(fileName, content);
        return content;
    }

    private void _addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) throws IOException {
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        for (String importLine : importLines) {
            int x = importLine.indexOf(34);
            int y = importLine.indexOf(34, x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            className = className.substring(className.lastIndexOf(46) + 1);
            if (!this._hasUnusedJSPTerm(fileName, "\\W" + className + "[^\\w\"]", "class", checkedFileNames, includeFileNames, this._getContentsMap())) continue;
            unneededImports.add(importLine);
        }
    }

    private synchronized Map<String, String> _getContentsMap() throws IOException {
        if (this._contentsMap != null) {
            return this._contentsMap;
        }
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> allJSPFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, new String[]{"**/*.jsp", "**/*.jspf", "**/*.tag"}, this.getSourceFormatterExcludes(), true);
        this._contentsMap = JSPSourceUtil.getContentsMap(allJSPFileNames);
        return this._contentsMap;
    }

    private List<String> _getJSPDuplicateImports(String fileName, String content, List<String> importLines) throws IOException {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 && (y = content.indexOf("<%@ tag import=")) == -1 || x >= y || !this._isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    private String _getVariableName(String line) {
        if (!line.endsWith(";") || line.startsWith("//")) {
            return null;
        }
        String variableName = null;
        int x = line.indexOf(" = ");
        if (x == -1) {
            int y = line.lastIndexOf(32);
            if (y != -1) {
                variableName = line.substring(y + 1, line.length() - 1);
            }
        } else {
            int y = (line = line.substring(0, x)).lastIndexOf(32);
            if (y != -1) {
                variableName = line.substring(y + 1);
            }
        }
        if (Validator.isVariableName(variableName)) {
            return variableName;
        }
        return null;
    }

    private boolean _hasUnusedJSPTerm(String fileName, String regex, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        includeFileNames.add(fileName);
        HashSet<String> checkedForUnusedJSPTerm = new HashSet<String>();
        return !this._isJSPTermRequired(fileName, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap);
    }

    private boolean _hasUnusedPortletDefineObjectsProperty(String fileName, String portletDefineObjectProperty, Set<String> checkedFileNames, Set<String> includeFileNames) throws IOException {
        return this._hasUnusedJSPTerm(fileName, "\\W" + portletDefineObjectProperty + "\\W", "portletDefineObjectProperty", checkedFileNames, includeFileNames, this._getContentsMap());
    }

    private boolean _hasUnusedVariable(String fileName, String line, Set<String> checkedFileNames, Set<String> includeFileNames) throws IOException {
        if (line.contains(": ")) {
            return false;
        }
        String variableName = this._getVariableName(line);
        if (Validator.isNull(variableName) || variableName.equals("false") || variableName.equals("true")) {
            return false;
        }
        return this._hasUnusedJSPTerm(fileName, "\\W" + variableName + "\\W", "variable", checkedFileNames, includeFileNames, this._getContentsMap());
    }

    private boolean _isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) throws IOException {
        Map<String, String> contentsMap = this._getContentsMap();
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1 && (x = importLine.indexOf("tag")) == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf(34, y)) == -1) {
            return false;
        }
        int z = content.indexOf(34, y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, this._getContentsMap());
        return this._isJSPDuplicateImport(includeFileName, importLine, true);
    }

    private boolean _isJSPTermRequired(String fileName, String regex, String type, Set<String> checkedForUnusedJSPTerm, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        String[] includeFileNamesArray;
        if (checkedForUnusedJSPTerm.contains(fileName)) {
            return false;
        }
        checkedForUnusedJSPTerm.add(fileName);
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        int count = 0;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJavaSource(content, matcher.start()) && ToolsUtil.isInsideQuotes(content, matcher.start() + 1)) continue;
            ++count;
        }
        if (count > 1 || count == 1 && (!type.equals("variable") || checkedForUnusedJSPTerm.size() > 1)) {
            return true;
        }
        if (!checkedForIncludesFileNames.contains(fileName)) {
            includeFileNames.addAll(JSPSourceUtil.getJSPIncludeFileNames(fileName, includeFileNames, contentsMap, false));
            includeFileNames.addAll(JSPSourceUtil.getJSPReferenceFileNames(fileName, includeFileNames, contentsMap));
        }
        checkedForIncludesFileNames.add(fileName);
        for (String includeFileName : includeFileNamesArray = includeFileNames.toArray(new String[0])) {
            if (checkedForUnusedJSPTerm.contains(includeFileName) || !this._isJSPTermRequired(includeFileName, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap)) continue;
            return true;
        }
        return false;
    }

    private String _removeUnusedImports(String fileName, String content) throws IOException {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = _compressedJSPImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        String newImports = StringUtil.replace(imports, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        ArrayList<String> importLines = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(newImports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=")) continue;
            importLines.add(line);
        }
        List<String> unneededImports = this._getJSPDuplicateImports(fileName, content, importLines);
        this._addJSPUnusedImports(fileName, importLines, unneededImports);
        for (String unneededImport : unneededImports) {
            newImports = StringUtil.replace(newImports, unneededImport, "");
        }
        return StringUtil.replaceFirst(content, imports, newImports);
    }

    private String _removeUnusedPortletDefineObjects(String fileName, String content) throws IOException {
        if (!content.contains("<portlet:defineObjects />\n")) {
            return content;
        }
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        for (String portletDefineObjectProperty : _PORTLET_DEFINE_OBJECTS_PROPERTIES) {
            if (this._hasUnusedPortletDefineObjectsProperty(fileName, portletDefineObjectProperty, checkedFileNames, includeFileNames)) continue;
            return content;
        }
        return StringUtil.removeSubstring(content, "<portlet:defineObjects />");
    }

    private String _removeUnusedTaglibs(String fileName, String content) throws IOException {
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        return this._removeUnusedTaglibs(fileName, content, checkedFileNames, includeFileNames);
    }

    private String _removeUnusedTaglibs(String fileName, String content, Set<String> checkedFileNames, Set<String> includeFileNames) throws IOException {
        Matcher matcher = _taglibURIPattern.matcher(content);
        while (matcher.find()) {
            String regex = StringBundler.concat("<", matcher.group(1), ":", "|", "\\$\\{" + matcher.group(1), ":");
            if (!this._hasUnusedJSPTerm(fileName, regex, "taglib", checkedFileNames, includeFileNames, this._getContentsMap())) continue;
            return StringUtil.removeSubstring(content, matcher.group());
        }
        return content;
    }

    private String _removeUnusedVariables(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/src/main/resources/alloy_mvc/jsp/") && absolutePath.endsWith(".jspf")) {
            return content;
        }
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            boolean javaSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                if (javaSource && !this.isExcludedPath(_UNUSED_VARIABLES_EXCLUDES, absolutePath, lineNumber) && this._hasUnusedVariable(fileName, trimmedLine, checkedFileNames, includeFileNames)) continue;
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

