/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class JSONPackageJSONCheck
extends BaseFileCheck {
    private Map<String, String> _expectedDependencyVersionsMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/package.json") || !absolutePath.contains("/modules/apps/")) {
            return content;
        }
        JSONObject jsonObject = new JSONObject(content);
        content = this._fixDependencyVersions(absolutePath, content, jsonObject);
        String dirName = absolutePath.substring(0, absolutePath.length() - 12);
        if (!FileUtil.exists(dirName + "build.gradle") && !FileUtil.exists(dirName + "bnd.bnd")) {
            return content;
        }
        this._checkIncorrectEntry(fileName, jsonObject, "devDependencies");
        if (jsonObject.isNull("scripts")) {
            return content;
        }
        JSONObject scriptsJSONObject = jsonObject.getJSONObject("scripts");
        if (absolutePath.contains("/modules/apps/frontend-theme")) {
            this._checkScript(fileName, scriptsJSONObject, "build", "liferay-npm-scripts theme build", false);
        } else {
            this._checkScript(fileName, scriptsJSONObject, "build", "liferay-npm-scripts build", false);
        }
        this._checkScript(fileName, scriptsJSONObject, "checkFormat", "liferay-npm-scripts lint", true);
        this._checkScript(fileName, scriptsJSONObject, "format", "liferay-npm-scripts format", true);
        return content;
    }

    private void _checkIncorrectEntry(String fileName, JSONObject jsonObject, String entryName) {
        if (!jsonObject.isNull(entryName)) {
            this.addMessage(fileName, "Entry '" + entryName + "' is not allowed");
        }
    }

    private void _checkScript(String fileName, JSONObject scriptsJSONObject, String key, String expectedValue, boolean requiredScript) {
        if (scriptsJSONObject.isNull(key)) {
            if (requiredScript) {
                this.addMessage(fileName, "Missing entry '" + key + "' in 'scripts'");
            }
            return;
        }
        String value = scriptsJSONObject.getString(key);
        if (!value.contains(expectedValue)) {
            this.addMessage(fileName, StringBundler.concat("Value '", value, "' for entry '", key, "' does not contain '", expectedValue, "'"));
        }
    }

    private String _fixDependencyVersions(String absolutePath, String content, JSONObject jsonObject) throws IOException {
        if (jsonObject.isNull("dependencies")) {
            return content;
        }
        Map<String, String> expectedDependencyVersionsMap = this._getExpectedDependencyVersionsMap(absolutePath);
        JSONObject dependenciesJSONObject = jsonObject.getJSONObject("dependencies");
        Iterator keys = dependenciesJSONObject.keys();
        while (keys.hasNext()) {
            String dependencyName = (String)keys.next();
            String actualVersion = dependenciesJSONObject.getString(dependencyName);
            String expectedVersion = expectedDependencyVersionsMap.get(dependencyName);
            if (expectedVersion == null || expectedVersion.equals(actualVersion)) continue;
            content = StringUtil.replace(content, StringBundler.concat("\"", dependencyName, "\": \"", actualVersion, "\""), StringBundler.concat("\"", dependencyName, "\": \"", expectedVersion, "\""));
        }
        return content;
    }

    private Map<String, String> _getDependencyVersionsMap(String fileName, String absolutePath, String regex) throws IOException {
        HashMap<String, String> dependencyVersionsMap = new HashMap<String, String>();
        String content = this.getPortalContent(fileName, absolutePath);
        if (Validator.isNull(content)) {
            return dependencyVersionsMap;
        }
        JSONObject jsonObject = new JSONObject(content);
        JSONObject dependenciesJSONObject = jsonObject.getJSONObject("dependencies");
        Iterator keys = dependenciesJSONObject.keys();
        while (keys.hasNext()) {
            String dependencyName = (String)keys.next();
            if (!dependencyName.matches(regex)) continue;
            dependencyVersionsMap.put(dependencyName, dependenciesJSONObject.getString(dependencyName));
        }
        return dependencyVersionsMap;
    }

    private synchronized Map<String, String> _getExpectedDependencyVersionsMap(String absolutePath) throws IOException {
        if (this._expectedDependencyVersionsMap != null) {
            return this._expectedDependencyVersionsMap;
        }
        this._expectedDependencyVersionsMap = new HashMap<String, String>();
        this._expectedDependencyVersionsMap.putAll(this._getDependencyVersionsMap("modules/apps/frontend-js/frontend-js-metal-web/package.json", absolutePath, "metal(-.*)?"));
        this._expectedDependencyVersionsMap.putAll(this._getDependencyVersionsMap("modules/apps/frontend-js/frontend-js-spa-web/package.json", absolutePath, "senna"));
        this._expectedDependencyVersionsMap.putAll(this._getDependencyVersionsMap("modules/apps/frontend-taglib/frontend-taglib-clay/package.json", absolutePath, "clay-.*"));
        return this._expectedDependencyVersionsMap;
    }
}

