/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependencyArtifactsCheck
extends BaseFileCheck {
    private static final String _ENFORCE_VERSION_ARTIFACTS_KEY = "enforceVersionArtifacts";
    private static final String _RENAME_ARTIFACTS_KEY = "renameArtifacts";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._renameDependencyArtifacts(absolutePath, content);
        return this._fixDependencyVersions(absolutePath, content);
    }

    private String _fixDependencyVersions(String absolutePath, String content) {
        List<String> enforceVersionArtifacts = this.getAttributeValues(_ENFORCE_VERSION_ARTIFACTS_KEY, absolutePath);
        for (String artifact : enforceVersionArtifacts) {
            String[] artifactParts = StringUtil.split(artifact, ":");
            Pattern pattern = Pattern.compile(StringBundler.concat("(group: \"", artifactParts[0], "\", name: \"", artifactParts[1], "\",.* version: \").*?(\")"));
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll("$1" + artifactParts[2] + "$2");
        }
        return content;
    }

    private String _getArtifactString(String artifact) {
        String[] array = StringUtil.split(artifact, ':');
        if (array.length != 2) {
            return null;
        }
        return StringBundler.concat("group: \"", array[0], "\", name: \"", array[1], "\"");
    }

    private String _renameDependencyArtifacts(String absolutePath, String content) {
        List<String> renameArtifacts = this.getAttributeValues(_RENAME_ARTIFACTS_KEY, absolutePath);
        for (String renameArtifact : renameArtifacts) {
            String[] renameArtifactArray = StringUtil.split(renameArtifact, "->");
            if (renameArtifactArray.length != 2) continue;
            String newArtifactString = this._getArtifactString(renameArtifactArray[1]);
            String oldArtifactString = this._getArtifactString(renameArtifactArray[0]);
            if (newArtifactString == null || oldArtifactString == null) continue;
            content = StringUtil.replace(content, oldArtifactString, newArtifactString);
        }
        return content;
    }
}

