/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import java.util.Locale;

@StatelessCheck
public class EmptyForIteratorPadCheck
extends AbstractCheck {
    public static final String MSG_WS_FOLLOWED = "ws.followed";
    public static final String MSG_WS_NOT_FOLLOWED = "ws.notFollowed";
    private static final String SEMICOLON = ";";
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        try {
            this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("unable to parse " + optionStr, iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{37};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            DetailAST semi = ast.getPreviousSibling();
            String line = this.getLines()[semi.getLineNo() - 1];
            int after = semi.getColumnNo() + 1;
            if (after < line.length()) {
                if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, MSG_WS_FOLLOWED, SEMICOLON);
                } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, MSG_WS_NOT_FOLLOWED, SEMICOLON);
                }
            }
        }
    }
}

