/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class BNDMultipleAppBNDsCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        int x = absolutePath.indexOf("/modules/private/apps/");
        if (x == -1) {
            return content;
        }
        String portalAppBNDFileName = StringUtil.replaceFirst(absolutePath.substring(x + 1), "/private/", "/");
        if (this.getPortalContent(portalAppBNDFileName, absolutePath, true) != null) {
            this.addMessage(fileName, "Redundant app.bnd. There is one already: '" + portalAppBNDFileName + "'.");
        }
        return content;
    }
}

