/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnusedVariableCheck
extends BaseCheck {
    private static final String _MSG_UNUSED_VARIABLE = "variable.unused";

    public int[] getDefaultTokens() {
        return new int[]{14, 8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 14 && detailAST.getParent() != null) {
            return;
        }
        List<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 10);
        if (variableDefinitionDetailASTList.isEmpty()) {
            return;
        }
        List<String> tokenNames = this._getTokenNames(detailAST);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            DetailAST modifiersDetailAST = variableDefinitionDetailAST.findFirstToken(5);
            if (detailAST.getType() != 14 ? modifiersDetailAST.getChildCount() > 0 : modifiersDetailAST.branchContains(159) || !modifiersDetailAST.branchContains(61)) continue;
            DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
            String variableName = nameDetailAST.getText();
            if (variableName.equals("serialVersionUID") || Collections.frequency(tokenNames, variableName) != 1) continue;
            this.log(variableDefinitionDetailAST, _MSG_UNUSED_VARIABLE, new Object[]{variableName});
        }
    }

    private List<String> _getTokenNames(DetailAST detailAST) {
        ArrayList<String> tokenNames = new ArrayList<String>();
        List<DetailAST> nameDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST nameDetailAST : nameDetailASTList) {
            tokenNames.add(nameDetailAST.getText());
        }
        return tokenNames;
    }
}

