/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;

public class PropertiesWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("\t")) {
                    line = line.replace("\t", "    ");
                }
                if (line.contains(" \t")) {
                    line = line.replace(" \t", "     ");
                }
                sb.append(line);
                sb.append("\n");
                if (!previousLine.matches("\\s+[^\\s#].*[,=]\\\\")) {
                    previousLine = line;
                    continue;
                }
                int leadingSpaceCount = this._getLeadingSpaceCount(line);
                int expectedLeadingSpaceCount = this._getLeadingSpaceCount(previousLine);
                if (previousLine.endsWith("=\\")) {
                    expectedLeadingSpaceCount += 4;
                }
                if (leadingSpaceCount != expectedLeadingSpaceCount) {
                    StringBundler sb2 = new StringBundler(5);
                    sb2.append("Line starts with '");
                    sb2.append(leadingSpaceCount);
                    sb2.append("' spaces, but '");
                    sb2.append(expectedLeadingSpaceCount);
                    sb2.append("' spaces are expected");
                    this.addMessage(fileName, sb2.toString(), lineNumber);
                }
                previousLine = line;
            }
        }
        content = sb.toString();
        return super.doProcess(fileName, absolutePath, content);
    }

    private int _getLeadingSpaceCount(String line) {
        int leadingSpaceCount = 0;
        while (line.startsWith(" ")) {
            line = line.substring(1);
            ++leadingSpaceCount;
        }
        return leadingSpaceCount;
    }
}

