/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAggregateTestRuleParameterOrderCheck
extends BaseFileCheck {
    private static final Pattern _aggregateTestRulePattern = Pattern.compile("new AggregateTestRule\\(");
    private static final Pattern _classNamePattern = Pattern.compile("(new )?([A-Z]\\w*?)[\\.\\(]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _aggregateTestRulePattern.matcher(content);
        block0: while (matcher.find()) {
            List<String> parametersList = JavaSourceUtil.getParameterList(content.substring(matcher.start()));
            if ("false".equals(parametersList.get(0))) {
                return content;
            }
            for (int i = 1; i < parametersList.size(); ++i) {
                String parameter = parametersList.get(i);
                String className = this._getClassName(parameter);
                String previousParameter = parametersList.get(i - 1);
                String previousClassName = this._getClassName(previousParameter);
                if (!Validator.isNotNull(className) || !Validator.isNotNull(previousClassName) || previousClassName.compareTo(className) <= 0) continue;
                content = StringUtil.replaceFirst(content, parameter, previousParameter, matcher.start());
                content = StringUtil.replaceFirst(content, previousParameter, parameter, matcher.start());
                continue block0;
            }
        }
        return content;
    }

    private String _getClassName(String parameterName) {
        Matcher matcher = _classNamePattern.matcher(parameterName);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }
}

