/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.comparator.JavaTermComparator;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class JavaTermOrderCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws DocumentException, IOException {
        Document customSQLDocument;
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains("@Meta.OCD")) {
            return javaTermContent;
        }
        String className = javaTerm.getName();
        String customSQLContent = null;
        if (absolutePath.contains("/persistence/") && className.endsWith("FinderImpl") && (customSQLDocument = this.getCustomSQLDocument(fileName, absolutePath, this.getPortalCustomSQLDocument())) != null && customSQLDocument.hasContent()) {
            customSQLContent = customSQLDocument.asXML();
        }
        return this._sortJavaTerms(fileName, absolutePath, (JavaClass)javaTerm, customSQLContent);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _sortJavaTerms(String fileName, String absolutePath, JavaClass javaClass, String customSQLContent) {
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        if (childJavaTerms.size() < 2) {
            return javaClass.getContent();
        }
        JavaTermComparator javaTermComparator = new JavaTermComparator(customSQLContent);
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : childJavaTerms) {
            if (javaTerm.isJavaStaticBlock() || Objects.equals(javaTerm.getAccessModifier(), "default")) continue;
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            int compare = javaTermComparator.compare(previousJavaTerm, javaTerm);
            if (compare == 0) {
                this.addMessage(fileName, "Duplicate " + javaTerm.getName());
            } else if (!this.isExcludedPath("javaterm.sort.excludes", absolutePath, previousJavaTerm.getName()) && !this.isExcludedPath("javaterm.sort.excludes", absolutePath, javaTerm.getName()) && compare > 0) {
                String classContent = javaClass.getContent();
                String newClassContent = StringUtil.replaceFirst(classContent, "\n" + previousJavaTerm.getContent(), "\n" + javaTerm.getContent());
                newClassContent = StringUtil.replaceLast(newClassContent, "\n" + javaTerm.getContent(), "\n" + previousJavaTerm.getContent());
                return newClassContent;
            }
            previousJavaTerm = javaTerm;
        }
        return javaClass.getContent();
    }
}

