/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.AudioProcessor;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.portal.fabric.InputResource;
import com.liferay.portal.fabric.OutputResource;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.util.LiferayAudioConverter;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.liferay.portlet.documentlibrary.util.XugglerAutoInstallHelper;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.time.StopWatch;

public class AudioProcessorImpl
extends DLPreviewableProcessor
implements AudioProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_CONTAINERS;
    private static final Log _log = LogFactoryUtil.getLog(AudioProcessorImpl.class);
    private static volatile ProcessExecutor _processExecutor = (ProcessExecutor)ServiceProxyFactory.newServiceTrackedInstance(ProcessExecutor.class, AudioProcessorImpl.class, (String)"_processExecutor", (boolean)true);
    private final Set<String> _audioMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_MIME_TYPES);
    private final List<Long> _fileVersionIds = new Vector<Long>();

    public void afterPropertiesSet() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            for (String previewType : _PREVIEW_TYPES) {
                if (previewType.equals("mp3") || previewType.equals("ogg")) continue;
                valid = false;
                break;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Liferay is incorrectly configured to generate video ");
            sb.append("previews using video containers other than MP3 or ");
            sb.append("OGG. Please change the property ");
            sb.append("dl.file.entry.preview.audio.containers");
            sb.append(" in portal-ext.properties.");
            _log.warn((Object)sb.toString());
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
    }

    public void generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateAudio(sourceFileVersion, destinationFileVersion);
    }

    public Set<String> getAudioMimeTypes() {
        return this._audioMimeTypes;
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public String getType() {
        return "AudioProcessor";
    }

    public boolean hasAudio(FileVersion fileVersion) {
        boolean hasAudio = false;
        try {
            hasAudio = this._hasAudio(fileVersion);
            if (!hasAudio && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasAudio;
    }

    public boolean isAudioSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isAudioSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        return this._audioMimeTypes.contains(mimeType) && XugglerUtil.isEnabled();
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
                return;
            }
            for (String previewType : _PREVIEW_TYPES) {
                if (!previewType.equals("mp3") && !previewType.equals("ogg")) continue;
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "audio", previewType);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return null;
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        for (String previewType : _PREVIEW_TYPES) {
            if (!previewType.equals("mp3") && !previewType.equals("ogg")) continue;
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "audio", previewType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block30: {
            String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
            File[] previewTempFiles = new File[_PREVIEW_TYPES.length];
            for (int i = 0; i < _PREVIEW_TYPES.length; ++i) {
                previewTempFiles[i] = this.getPreviewTempFile(tempFileId, _PREVIEW_TYPES[i]);
            }
            File audioTempFile = null;
            try {
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (!XugglerUtil.isEnabled() || this._hasAudio(destinationFileVersion)) {
                    return;
                }
                audioTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                if (this.hasPreviews(destinationFileVersion)) break block30;
                File file = null;
                if (destinationFileVersion instanceof LiferayFileVersion) {
                    try {
                        LiferayFileVersion liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                        file = liferayFileVersion.getFile(false);
                    }
                    catch (UnsupportedOperationException liferayFileVersion) {
                        // empty catch block
                    }
                }
                if (file == null) {
                    try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                        FileUtil.write((File)audioTempFile, (InputStream)inputStream);
                        file = audioTempFile;
                    }
                }
                try {
                    this._generateAudioXuggler(destinationFileVersion, file, previewTempFiles);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfee, (Throwable)nsfee);
                }
            }
            finally {
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                for (int i = 0; i < previewTempFiles.length; ++i) {
                    FileUtil.delete((File)previewTempFiles[i]);
                }
                FileUtil.delete((File)audioTempFile);
            }
        }
    }

    private void _generateAudioXuggler(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                LiferayAudioProcessCallable processCallable = new LiferayAudioProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), srcFile, destFile, containerType, PropsUtil.getProperties("dl.file.entry.preview.audio.", false));
                ProcessChannel processChannel = _processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), (ProcessCallable)processCallable);
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                String processIdentity = String.valueOf(fileVersion.getFileVersionId());
                this.futures.put(processIdentity, future);
                future.get();
            } else {
                LiferayAudioConverter liferayConverter = new LiferayAudioConverter(srcFile.getCanonicalPath(), destFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.audio.", false));
                ((LiferayConverter)liferayConverter).convert();
            }
        }
        catch (CancellationException ce) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Cancellation received for ", String.valueOf(fileVersion.getFileVersionId()), " ", fileVersion.getTitle()}));
            }
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to process ", String.valueOf(fileVersion.getFileVersionId()), " ", fileVersion.getTitle(), "."}), (Throwable)e);
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Xuggler generated a ", containerType, " preview audio for ", String.valueOf(fileVersion.getFileVersionId()), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
        }
    }

    private void _generateAudioXuggler(FileVersion fileVersion, File srcFile, File[] destFiles) {
        try {
            for (int i = 0; i < destFiles.length; ++i) {
                this._generateAudioXuggler(fileVersion, srcFile, destFiles[i], _PREVIEW_TYPES[i]);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private boolean _hasAudio(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_audio_processor", sourceFileVersion, destinationFileVersion);
    }

    private static class LiferayAudioProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final String _audioContainer;
        private final Properties _audioProperties;
        private final Map<String, String> _customLogSettings;
        @InputResource
        private final File _inputFile;
        private final String _liferayHome;
        @OutputResource
        private final File _outputFile;
        private final String _serverId;

        public LiferayAudioProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, File inputFile, File outputFile, String audioContainer, Properties audioProperties) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputFile = inputFile;
            this._outputFile = outputFile;
            this._audioContainer = audioContainer;
            this._audioProperties = audioProperties;
        }

        public String call() throws ProcessException {
            XugglerAutoInstallHelper.installNativeLibraries();
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayAudioConverter liferayConverter = new LiferayAudioConverter(this._inputFile.getCanonicalPath(), this._outputFile.getCanonicalPath(), this._audioContainer, this._audioProperties);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            return "";
        }
    }
}

