/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthToken;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.SecurityPortletContainerWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SessionAuthToken
implements AuthToken {
    private static final String _CSRF = "#CSRF";
    private static final Log _log = LogFactoryUtil.getLog(SessionAuthToken.class);

    public void addCSRFToken(HttpServletRequest request, LiferayPortletURL liferayPortletURL) {
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String lifecycle = liferayPortletURL.getLifecycle();
        if (!lifecycle.equals("ACTION_PHASE")) {
            return;
        }
        if (AuthTokenWhitelistUtil.isPortletURLCSRFWhitelisted((LiferayPortletURL)liferayPortletURL)) {
            return;
        }
        liferayPortletURL.setParameter("p_auth", this.getToken(request));
    }

    public void addPortletInvocationToken(HttpServletRequest request, LiferayPortletURL liferayPortletURL) {
        long plid;
        String portletId;
        block7: {
            if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
                return;
            }
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)(portletId = liferayPortletURL.getPortletId()));
            if (portlet == null) {
                return;
            }
            if (!portlet.isAddDefaultResource()) {
                return;
            }
            if (AuthTokenWhitelistUtil.isPortletURLPortletInvocationWhitelisted((LiferayPortletURL)liferayPortletURL)) {
                return;
            }
            plid = liferayPortletURL.getPlid();
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasPortletId(portletId)) {
                    return;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        liferayPortletURL.setParameter("p_p_auth", this.getToken(request, plid, portletId));
    }

    @Deprecated
    public void check(HttpServletRequest request) throws PrincipalException {
        this.checkCSRFToken(request, SecurityPortletContainerWrapper.class.getName());
    }

    public void checkCSRFToken(HttpServletRequest request, String origin) throws PrincipalException {
        String sessionToken;
        String ppid;
        Portlet portlet;
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String sharedSecret = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth_secret");
        if (AuthTokenWhitelistUtil.isValidSharedSecret((String)sharedSecret)) {
            return;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (AuthTokenWhitelistUtil.isOriginCSRFWhitelisted((long)companyId, (String)origin)) {
            return;
        }
        if (origin.equals(SecurityPortletContainerWrapper.class.getName()) && AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((HttpServletRequest)request, (Portlet)(portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)(ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id")))))) {
            return;
        }
        String csrfToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth");
        if (Validator.isNull((String)csrfToken)) {
            csrfToken = GetterUtil.getString((String)request.getHeader("X-CSRF-Token"));
        }
        if (!csrfToken.equals(sessionToken = this.getSessionAuthenticationToken(request, _CSRF, false))) {
            throw new PrincipalException.MustBeAuthenticated(PortalUtil.getUserId((HttpServletRequest)request));
        }
    }

    public String getToken(HttpServletRequest request) {
        return this.getSessionAuthenticationToken(request, _CSRF, true);
    }

    public String getToken(HttpServletRequest request, long plid, String portletId) {
        return this.getSessionAuthenticationToken(request, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId), true);
    }

    public boolean isValidPortletInvocationToken(HttpServletRequest request, Layout layout, Portlet portlet) {
        String key;
        String sessionToken;
        if (AuthTokenWhitelistUtil.isPortletInvocationWhitelisted((HttpServletRequest)request, (Portlet)portlet)) {
            return true;
        }
        long plid = layout.getPlid();
        String portletId = portlet.getPortletId();
        String portletToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_auth");
        if (Validator.isNull((String)portletToken)) {
            HttpServletRequest originalRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
            portletToken = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"p_p_auth");
        }
        return Validator.isNotNull((String)portletToken) && Validator.isNotNull((String)(sessionToken = this.getSessionAuthenticationToken(request, key = PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId), false))) && sessionToken.equals(portletToken);
    }

    @Deprecated
    public boolean isValidPortletInvocationToken(HttpServletRequest request, long plid, String portletId, String strutsAction, String tokenValue) {
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
            return this.isValidPortletInvocationToken(request, layout, portlet);
        }
        catch (PortalException pe) {
            ReflectionUtil.throwException((Throwable)pe);
            return false;
        }
    }

    protected String getSessionAuthenticationToken(HttpServletRequest request, String key, boolean createToken) {
        String sessionAuthenticationToken = null;
        HttpServletRequest currentRequest = request;
        HttpSession session = null;
        String tokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key);
        while (currentRequest instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentRequest;
            session = currentRequest.getSession();
            sessionAuthenticationToken = (String)session.getAttribute(tokenKey);
            if (Validator.isNotNull((String)sessionAuthenticationToken)) break;
            currentRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (session == null) {
            session = currentRequest.getSession();
            sessionAuthenticationToken = (String)session.getAttribute(tokenKey);
        }
        if (createToken && Validator.isNull(sessionAuthenticationToken)) {
            sessionAuthenticationToken = PwdGenerator.getPassword((int)PropsValues.AUTH_TOKEN_LENGTH);
            session.setAttribute(tokenKey, (Object)sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }
}

