/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.velocity.ColumnProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateProcessor
implements ColumnProcessor {
    private static final RenderWeightComparator _renderWeightComparator = new RenderWeightComparator();
    private final Portlet _portlet;
    private final boolean _portletAjaxRender;
    private final Map<Integer, List<PortletRenderer>> _portletRenderers;
    private final HttpServletRequest _request;
    private final HttpServletResponse _response;

    public TemplateProcessor(HttpServletRequest request, HttpServletResponse response, String portletId) {
        this._request = request;
        this._response = response;
        if (Validator.isNotNull((String)portletId)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        } else {
            this._portlet = null;
        }
        this._portletAjaxRender = GetterUtil.getBoolean((Object)request.getAttribute("PORTLET_AJAX_RENDER"));
        this._portletRenderers = new TreeMap<Integer, List<PortletRenderer>>(_renderWeightComparator);
    }

    public Map<Integer, List<PortletRenderer>> getPortletRenderers() {
        return this._portletRenderers;
    }

    public boolean isPortletAjaxRender() {
        return this._portletAjaxRender;
    }

    @Override
    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    @Override
    public String processColumn(String columnId, String classNames) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        List portlets = layoutTypePortlet.getAllPortlets(columnId);
        StringBundler sb = new StringBundler(portlets.size() * 3 + 10);
        sb.append("<div class=\"portlet-dropzone");
        if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isColumnDisabled(columnId)) {
            sb.append(" portlet-dropzone-disabled");
        }
        if (layoutTypePortlet.isColumnCustomizable(columnId)) {
            sb.append(" customizable");
        }
        if (portlets.isEmpty()) {
            sb.append(" empty");
        }
        if (Validator.isNotNull((String)classNames)) {
            sb.append(" ");
            sb.append(classNames);
        }
        sb.append("\" id=\"layout-column_");
        sb.append(columnId);
        sb.append("\">");
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = (Portlet)portlets.get(i);
            Integer columnCount = portlets.size();
            Integer columnPos = i;
            PortletRenderer portletRenderer = new PortletRenderer(portlet, columnId, columnCount, columnPos);
            if (this._portletAjaxRender && portlet.getRenderWeight() < 1) {
                StringBundler renderResultSB = portletRenderer.renderAjax(this._request, this._response);
                sb.append(renderResultSB);
                continue;
            }
            Integer renderWeight = portlet.getRenderWeight();
            List<PortletRenderer> portletRenderers = this._portletRenderers.get(renderWeight);
            if (portletRenderers == null) {
                portletRenderers = new ArrayList<PortletRenderer>();
                this._portletRenderers.put(renderWeight, portletRenderers);
            }
            portletRenderers.add(portletRenderer);
            sb.append("[$TEMPLATE_PORTLET_");
            sb.append(portlet.getPortletId());
            sb.append("$]");
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    public String processMax() throws Exception {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._response);
        PortletContainerUtil.render((HttpServletRequest)this._request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
        return bufferCacheServletResponse.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processPortlet(String portletId) throws Exception {
        this._request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._response);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        PortletJSONUtil.populatePortletJSONObject((HttpServletRequest)this._request, (String)"", (Portlet)portlet, (JSONObject)jsonObject);
        try {
            PortletJSONUtil.writeHeaderPaths((HttpServletResponse)this._response, (JSONObject)jsonObject);
            PortletContainerUtil.render((HttpServletRequest)this._request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)portlet);
            PortletJSONUtil.writeFooterPaths((HttpServletResponse)this._response, (JSONObject)jsonObject);
            String string = bufferCacheServletResponse.getString();
            return string;
        }
        finally {
            this._request.removeAttribute("RENDER_PORTLET_RESOURCE");
        }
    }

    @Override
    public String processPortlet(String portletId, Map<String, ?> defaultSettingsMap) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(themeDisplay.getLayout(), portletId));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        for (Map.Entry<String, ?> entry : defaultSettingsMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                modifiableSettings.setValue(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                modifiableSettings.setValues(key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Key ", key, " has unsupported value of type ", ClassUtil.getClassName(value.getClass())}));
        }
        modifiableSettings.store();
        return this.processPortlet(portletId);
    }

    @Override
    public String processPortlet(String portletProviderClassName, PortletProvider.Action portletProviderAction) throws Exception {
        String portletId = PortletProviderUtil.getPortletId((String)portletProviderClassName, (PortletProvider.Action)portletProviderAction);
        return this.processPortlet(portletId);
    }

    private static class RenderWeightComparator
    implements Comparator<Integer> {
        private RenderWeightComparator() {
        }

        @Override
        public int compare(Integer renderWeight1, Integer renderWeight2) {
            return renderWeight2 - renderWeight1;
        }
    }
}

