/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.memory;

import com.liferay.portal.kernel.memory.PoolAction;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class SoftReferencePool<V, P> {
    public static final int DEFAULT_IDLE_SIZE = 8;
    private final int _maxIdleSize;
    private final PoolAction<V, P> _poolAction;
    private final ReferenceQueue<V> _referenceQueue = new ReferenceQueue();
    private final Queue<SoftReference<? extends V>> _softReferences = new ConcurrentLinkedQueue<SoftReference<? extends V>>();
    private final boolean _useWeakCounter;
    private final AtomicInteger _weakCounter;

    public SoftReferencePool(PoolAction<V, P> poolAction) {
        this(poolAction, 8);
    }

    public SoftReferencePool(PoolAction<V, P> poolAction, int maxIdleSize) {
        this(poolAction, maxIdleSize, true);
    }

    public SoftReferencePool(PoolAction<V, P> poolAction, int maxIdleSize, boolean useWeakCounter) {
        this._poolAction = poolAction;
        this._maxIdleSize = maxIdleSize;
        this._useWeakCounter = useWeakCounter;
        this._weakCounter = this._useWeakCounter ? new AtomicInteger() : null;
    }

    public V borrowObject(P parameter) {
        SoftReference<V> softReference;
        V value;
        do {
            if ((softReference = this._softReferences.poll()) == null) {
                return this._poolAction.onCreate(parameter);
            }
            if (!this._useWeakCounter) continue;
            this._weakCounter.getAndDecrement();
        } while ((value = softReference.get()) == null);
        return this._poolAction.onBorrow(value, parameter);
    }

    public void returnObject(V value) {
        SoftReference softReference;
        if (this._getCount() < this._maxIdleSize) {
            softReference = new SoftReference(value, this._referenceQueue);
            this._poolAction.onReturn(value);
            this._softReferences.offer(softReference);
            if (this._useWeakCounter) {
                this._weakCounter.getAndIncrement();
            }
        } else {
            while (this._getCount() > this._maxIdleSize) {
                if (this._softReferences.poll() == null || !this._useWeakCounter) continue;
                this._weakCounter.getAndDecrement();
            }
        }
        softReference = null;
        while ((softReference = (SoftReference)this._referenceQueue.poll()) != null) {
            if (!this._softReferences.remove(softReference) || !this._useWeakCounter) continue;
            this._weakCounter.getAndDecrement();
        }
    }

    private int _getCount() {
        if (this._useWeakCounter) {
            return this._weakCounter.get();
        }
        return this._softReferences.size();
    }
}

