/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaForLoopCheck
extends BaseJavaTermCheck {
    private final Pattern _arrayPattern = Pattern.compile("\tfor \\(int (\\w+) = 0;\\s+(\\w+) < (\\w+)\\.length;\\s+(\\w+)\\+\\+\\) \\{\n\\s+([\\w\\[\\]]+) (\\w+) =\\s+(\\w+)\\[(\\w+)\\];\n");
    private final Pattern _listPattern = Pattern.compile("\tfor \\(int (\\w+) = 0;\\s+(\\w+) < (\\w+)\\.size\\(\\);\\s+(\\w+)\\+\\+\\) \\{\n\\s+([\\w<>]+) (\\w+) =\\s+(\\w+)\\.get\\((\\w+)\\);\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent = this._formatForLoop(javaTerm.getContent(), this._arrayPattern);
        return this._formatForLoop(javaTermContent, this._listPattern);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private String _formatForLoop(String javaTermContent, Pattern pattern) {
        Matcher matcher = pattern.matcher(javaTermContent);
        while (matcher.find()) {
            String s;
            String collectionVariableName = matcher.group(3);
            String countVariableName = matcher.group(1);
            if (!Objects.equals(collectionVariableName, matcher.group(7)) || !Objects.equals(countVariableName, matcher.group(2)) || !Objects.equals(countVariableName, matcher.group(4)) || !Objects.equals(countVariableName, matcher.group(8))) continue;
            int x = matcher.end();
            do {
                if ((x = javaTermContent.indexOf("}", x + 1)) != -1) continue;
                return javaTermContent;
            } while (ToolsUtil.isInsideQuotes(javaTermContent, x) || this.getLevel(s = javaTermContent.substring(matcher.end(), x), "{", "}") != 0);
            if (s.matches("(?s).*\\W" + countVariableName + "\\W.*")) continue;
            StringBundler sb = new StringBundler(7);
            sb.append("\tfor (");
            sb.append(matcher.group(5));
            sb.append(" ");
            sb.append(matcher.group(6));
            sb.append(" : ");
            sb.append(collectionVariableName);
            sb.append(") {\n");
            return StringUtil.replaceFirst(javaTermContent, matcher.group(), sb.toString(), matcher.start());
        }
        return javaTermContent;
    }
}

