/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portlet.FilterConfigImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.portlet.filter.FilterConfig;

public class FilterConfigFactory {
    private static final FilterConfigFactory _instance = new FilterConfigFactory();
    private final Map<String, Map<String, FilterConfig>> _pool = new ConcurrentHashMap<String, Map<String, FilterConfig>>();

    public static FilterConfig create(PortletFilter portletFilter, PortletContext ctx) {
        return _instance._create(portletFilter, ctx);
    }

    public static void destroy(PortletFilter portletFilter) {
        _instance._destroy(portletFilter);
    }

    private FilterConfigFactory() {
    }

    private FilterConfig _create(PortletFilter portletFilter, PortletContext ctx) {
        FilterConfig filterConfig;
        PortletApp portletApp = portletFilter.getPortletApp();
        Map<String, FilterConfig> filterConfigs = this._pool.get(portletApp.getServletContextName());
        if (filterConfigs == null) {
            filterConfigs = new ConcurrentHashMap<String, FilterConfig>();
            this._pool.put(portletApp.getServletContextName(), filterConfigs);
        }
        if ((filterConfig = filterConfigs.get(portletFilter.getFilterName())) == null) {
            filterConfig = new FilterConfigImpl(portletFilter.getFilterName(), ctx, portletFilter.getInitParams());
            filterConfigs.put(portletFilter.getFilterName(), filterConfig);
        }
        return filterConfig;
    }

    private void _destroy(PortletFilter portletFilter) {
        PortletApp portletApp = portletFilter.getPortletApp();
        this._pool.remove(portletApp.getServletContextName());
    }
}

