/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.NotificationEventFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.UserNotificationEventLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class UserNotificationEventLocalServiceImpl
extends UserNotificationEventLocalServiceBaseImpl {
    public UserNotificationEvent addUserNotificationEvent(long userId, boolean actionRequired, NotificationEvent notificationEvent) throws PortalException {
        JSONObject payloadJSONObject = notificationEvent.getPayload();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUuid(notificationEvent.getUuid());
        return this.addUserNotificationEvent(userId, notificationEvent.getType(), notificationEvent.getTimestamp(), notificationEvent.getDeliveryType(), notificationEvent.getDeliverBy(), payloadJSONObject.toString(), actionRequired, notificationEvent.isArchived(), serviceContext);
    }

    public UserNotificationEvent addUserNotificationEvent(long userId, NotificationEvent notificationEvent) throws PortalException {
        return this.addUserNotificationEvent(userId, false, notificationEvent);
    }

    public UserNotificationEvent addUserNotificationEvent(long userId, String type, long timestamp, int deliveryType, long deliverBy, String payload, boolean actionRequired, boolean archived, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long userNotificationEventId = this.counterLocalService.increment();
        UserNotificationEvent userNotificationEvent = this.userNotificationEventPersistence.create(userNotificationEventId);
        userNotificationEvent.setUuid(serviceContext.getUuid());
        userNotificationEvent.setCompanyId(user.getCompanyId());
        userNotificationEvent.setUserId(userId);
        userNotificationEvent.setType(type);
        userNotificationEvent.setTimestamp(timestamp);
        userNotificationEvent.setDeliveryType(deliveryType);
        userNotificationEvent.setDeliverBy(deliverBy);
        userNotificationEvent.setDelivered(true);
        userNotificationEvent.setPayload(payload);
        userNotificationEvent.setActionRequired(actionRequired);
        userNotificationEvent.setArchived(archived);
        this.userNotificationEventPersistence.update((BaseModel)userNotificationEvent);
        return userNotificationEvent;
    }

    public UserNotificationEvent addUserNotificationEvent(long userId, String type, long timestamp, int deliveryType, long deliverBy, String payload, boolean archived, ServiceContext serviceContext) throws PortalException {
        return this.addUserNotificationEvent(userId, type, timestamp, deliveryType, deliverBy, payload, false, archived, serviceContext);
    }

    @Deprecated
    public UserNotificationEvent addUserNotificationEvent(long userId, String type, long timestamp, long deliverBy, String payload, boolean archived, ServiceContext serviceContext) throws PortalException {
        return this.addUserNotificationEvent(userId, type, timestamp, 10002, deliverBy, payload, archived, serviceContext);
    }

    public List<UserNotificationEvent> addUserNotificationEvents(long userId, Collection<NotificationEvent> notificationEvents) throws PortalException {
        ArrayList<UserNotificationEvent> userNotificationEvents = new ArrayList<UserNotificationEvent>(notificationEvents.size());
        for (NotificationEvent notificationEvent : notificationEvents) {
            UserNotificationEvent userNotificationEvent = this.addUserNotificationEvent(userId, notificationEvent);
            userNotificationEvents.add(userNotificationEvent);
        }
        return userNotificationEvents;
    }

    public void archiveUserNotificationEvents(long userId, int deliveryType, boolean actionRequired) throws PortalException {
        int userNotificationEventsCount = this.getArchivedUserNotificationEventsCount(userId, deliveryType, actionRequired, false);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(userNotificationEventsCount);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List<UserNotificationEvent> userNotificationEvents = this.getArchivedUserNotificationEvents(userId, deliveryType, actionRequired, false, start, end);
            for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
                userNotificationEvent.setArchived(true);
                this.updateUserNotificationEvent(userNotificationEvent);
            }
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    public void deleteUserNotificationEvent(String uuid, long companyId) {
        this.userNotificationEventPersistence.removeByUuid_C(uuid, companyId);
    }

    public void deleteUserNotificationEvents(Collection<String> uuids, long companyId) {
        for (String uuid : uuids) {
            this.deleteUserNotificationEvent(uuid, companyId);
        }
    }

    public void deleteUserNotificationEvents(long userId) {
        this.userNotificationEventPersistence.removeByUserId(userId);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, boolean archived) {
        return this.userNotificationEventPersistence.findByU_A(userId, archived);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, boolean actionRequired, boolean archived) {
        return this.userNotificationEventPersistence.findByU_A_A(userId, actionRequired, archived);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, boolean actionRequired, boolean archived, int start, int end) {
        return this.userNotificationEventPersistence.findByU_A_A(userId, actionRequired, archived, start, end);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, boolean archived, int start, int end) {
        return this.userNotificationEventPersistence.findByU_A(userId, archived, start, end);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, int deliveryType, boolean archived) {
        return this.userNotificationEventPersistence.findByU_DT_A(userId, deliveryType, archived);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, int deliveryType, boolean actionRequired, boolean archived) {
        return this.userNotificationEventPersistence.findByU_DT_A_A(userId, deliveryType, actionRequired, archived);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, int deliveryType, boolean actionRequired, boolean archived, int start, int end) {
        return this.userNotificationEventPersistence.findByU_DT_A_A(userId, deliveryType, actionRequired, archived, start, end);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, int deliveryType, boolean actionRequired, boolean archived, int start, int end, OrderByComparator<UserNotificationEvent> obc) {
        return this.userNotificationEventPersistence.findByU_DT_A_A(userId, deliveryType, actionRequired, archived, start, end, obc);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, int deliveryType, boolean archived, int start, int end) {
        return this.userNotificationEventPersistence.findByU_DT_A(userId, deliveryType, archived, start, end);
    }

    public int getArchivedUserNotificationEventsCount(long userId, boolean archived) {
        return this.userNotificationEventPersistence.countByU_A(userId, archived);
    }

    public int getArchivedUserNotificationEventsCount(long userId, boolean actionRequired, boolean archived) {
        return this.userNotificationEventPersistence.countByU_A_A(userId, actionRequired, archived);
    }

    public int getArchivedUserNotificationEventsCount(long userId, int deliveryType, boolean archived) {
        return this.userNotificationEventPersistence.countByU_DT_A(userId, deliveryType, archived);
    }

    public int getArchivedUserNotificationEventsCount(long userId, int deliveryType, boolean actionRequired, boolean archived) {
        return this.userNotificationEventPersistence.countByU_DT_A_A(userId, deliveryType, actionRequired, archived);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, boolean delivered) {
        return this.userNotificationEventPersistence.findByU_D(userId, delivered);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, boolean delivered, boolean actionRequired) {
        return this.userNotificationEventPersistence.findByU_D_A(userId, delivered, actionRequired);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, boolean delivered, boolean actionRequired, int start, int end) {
        return this.userNotificationEventPersistence.findByU_D_A(userId, delivered, actionRequired, start, end);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, boolean delivered, int start, int end) {
        return this.userNotificationEventPersistence.findByU_D(userId, delivered, start, end);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, int deliveryType, boolean delivered) {
        return this.userNotificationEventPersistence.findByU_DT_D(userId, deliveryType, delivered);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, int deliveryType, boolean delivered, boolean actionRequired) {
        return this.userNotificationEventPersistence.findByU_DT_D_A(userId, deliveryType, delivered, actionRequired);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, int deliveryType, boolean delivered, boolean actionRequired, int start, int end) {
        return this.userNotificationEventPersistence.findByU_DT_D_A(userId, deliveryType, delivered, actionRequired, start, end);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, int deliveryType, boolean delivered, boolean actionRequired, int start, int end, OrderByComparator<UserNotificationEvent> obc) {
        return this.userNotificationEventPersistence.findByU_DT_D_A(userId, deliveryType, delivered, actionRequired, start, end, obc);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, int deliveryType, boolean delivered, int start, int end) {
        return this.userNotificationEventPersistence.findByU_DT_D(userId, deliveryType, delivered, start, end);
    }

    public int getDeliveredUserNotificationEventsCount(long userId, boolean delivered) {
        return this.userNotificationEventPersistence.countByU_D(userId, delivered);
    }

    public int getDeliveredUserNotificationEventsCount(long userId, boolean delivered, boolean actionRequired) {
        return this.userNotificationEventPersistence.countByU_D_A(userId, delivered, actionRequired);
    }

    public int getDeliveredUserNotificationEventsCount(long userId, int deliveryType, boolean delivered) {
        return this.userNotificationEventPersistence.countByU_DT_D(userId, deliveryType, delivered);
    }

    public int getDeliveredUserNotificationEventsCount(long userId, int deliveryType, boolean delivered, boolean actionRequired) {
        return this.userNotificationEventPersistence.countByU_DT_D_A(userId, deliveryType, delivered, actionRequired);
    }

    public List<UserNotificationEvent> getTypeNotificationEvents(String type) {
        return this.userNotificationEventPersistence.findByType(type);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId) {
        return this.userNotificationEventPersistence.findByUserId(userId);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId, int deliveryType) {
        return this.userNotificationEventPersistence.findByU_DT(userId, deliveryType);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId, int start, int end) {
        return this.userNotificationEventPersistence.findByUserId(userId, start, end);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId, int deliveryType, int start, int end) {
        return this.userNotificationEventPersistence.findByU_DT(userId, deliveryType, start, end);
    }

    public int getUserNotificationEventsCount(long userId) {
        return this.userNotificationEventPersistence.countByUserId(userId);
    }

    public int getUserNotificationEventsCount(long userId, int deliveryType) {
        return this.userNotificationEventPersistence.countByU_DT(userId, deliveryType);
    }

    public int getUserNotificationEventsCount(long userId, String type, int deliveryType, boolean archived) {
        return this.userNotificationEventPersistence.countByU_T_DT_D(userId, type, deliveryType, archived);
    }

    public UserNotificationEvent sendUserNotificationEvents(long userId, String portletId, int deliveryType, boolean actionRequired, JSONObject notificationEventJSONObject) throws PortalException {
        NotificationEvent notificationEvent = NotificationEventFactoryUtil.createNotificationEvent((long)System.currentTimeMillis(), (String)portletId, (JSONObject)notificationEventJSONObject);
        notificationEvent.setDeliveryType(deliveryType);
        UserNotificationEvent userNotificationEvent = this.addUserNotificationEvent(userId, actionRequired, notificationEvent);
        if (deliveryType == 10005) {
            this.sendPushNotification(notificationEvent);
        }
        return userNotificationEvent;
    }

    public UserNotificationEvent sendUserNotificationEvents(long userId, String portletId, int deliveryType, JSONObject notificationEventJSONObject) throws PortalException {
        return this.sendUserNotificationEvents(userId, portletId, deliveryType, false, notificationEventJSONObject);
    }

    public UserNotificationEvent updateUserNotificationEvent(String uuid, long companyId, boolean archive) {
        List userNotificationEvents = this.userNotificationEventPersistence.findByUuid_C(uuid, companyId);
        if (userNotificationEvents.isEmpty()) {
            return null;
        }
        UserNotificationEvent userNotificationEvent = (UserNotificationEvent)userNotificationEvents.get(0);
        userNotificationEvent.setArchived(archive);
        this.userNotificationEventPersistence.update((BaseModel)userNotificationEvent);
        return userNotificationEvent;
    }

    public List<UserNotificationEvent> updateUserNotificationEvents(Collection<String> uuids, long companyId, boolean archive) {
        ArrayList<UserNotificationEvent> userNotificationEvents = new ArrayList<UserNotificationEvent>();
        for (String uuid : uuids) {
            userNotificationEvents.add(this.updateUserNotificationEvent(uuid, companyId, archive));
        }
        return userNotificationEvents;
    }

    protected void sendPushNotification(final NotificationEvent notificationEvent) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.setPayload((Object)notificationEvent.getPayload());
                MessageBusUtil.sendMessage((String)"liferay/push_notification", (Message)message);
                return null;
            }
        });
    }
}

