/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.util.GetterUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class JSONRPCResponse
implements JSONSerializable {
    private final Error _error;
    private final Integer _id;
    private final String _jsonrpc;
    private final Object _result;

    public JSONRPCResponse(JSONRPCRequest jsonRPCRequest, Object result, Exception exception) {
        this._jsonrpc = GetterUtil.getString((String)jsonRPCRequest.getJsonrpc());
        Error error = null;
        if (!this._jsonrpc.equals("2.0")) {
            error = new Error(-32700, "Invalid JSON RPC version " + this._jsonrpc);
            result = null;
        } else if (exception != null) {
            int code = -32603;
            String message = null;
            if (exception instanceof InvocationTargetException) {
                code = -32602;
                Throwable cause = exception.getCause();
                message = cause.toString();
            } else {
                message = exception.toString();
            }
            if (message == null) {
                message = exception.toString();
            }
            error = new Error(code, message);
            result = null;
        }
        this._error = error;
        this._id = jsonRPCRequest.getId();
        this._result = result;
    }

    public String toJSONString() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (this._error != null) {
            response.put("error", this._error);
        }
        if (this._id != null) {
            response.put("id", this._id);
        }
        if (this._jsonrpc != null) {
            response.put("jsonrpc", "2.0");
        }
        if (this._result != null) {
            response.put("result", this._result);
        }
        JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
        jsonSerializer.exclude(new String[]{"*.class"});
        jsonSerializer.include(new String[]{"error", "result"});
        return jsonSerializer.serialize(response);
    }

    public class Error {
        private final int _code;
        private final String _message;

        public Error(int code, String message) {
            this._code = code;
            this._message = message;
        }

        public int getCode() {
            return this._code;
        }

        public String getMessage() {
            return this._message;
        }
    }
}

